/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.crm.web;

import com.axelor.apps.ReportFactory;
import com.axelor.apps.base.db.ImportConfiguration;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.repo.ImportConfigurationRepository;
import com.axelor.apps.base.service.MapService;
import com.axelor.apps.crm.db.Lead;
import com.axelor.apps.crm.db.repo.LeadRepository;
import com.axelor.apps.crm.service.LeadService;
import com.axelor.apps.report.engine.ReportSettings;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.Singleton;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class LeadController {
    private final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public void print(ActionRequest request, ActionResponse response) throws AxelorException {
        Lead lead = (Lead)((Object)request.getContext().asType(Lead.class));
        String leadIds = "";
        List lstSelectedleads = (List)request.getContext().get((Object)"_ids");
        if (lstSelectedleads != null) {
            for (Integer it : lstSelectedleads) {
                leadIds = leadIds + it.toString() + ",";
            }
        }
        if (!leadIds.equals("")) {
            leadIds = leadIds.substring(0, leadIds.length() - 1);
            lead = (Lead)((Object)((LeadRepository)((Object)Beans.get(LeadRepository.class))).find(new Long(((Integer)lstSelectedleads.get(0)).intValue())));
        } else if (lead.getId() != null) {
            leadIds = lead.getId().toString();
        }
        if (!leadIds.equals("")) {
            String title = " ";
            if (lead.getFirstName() != null) {
                title = title + (lstSelectedleads == null ? "Lead " + lead.getFirstName() : "Leads");
            }
            String fileLink = ReportFactory.createReport((String)"Lead.rptdesign", (String)(title + "-${date}")).addParam("LeadId", (Object)leadIds).addParam("Locale", (Object)ReportSettings.getPrintingLocale((Partner)lead.getPartner())).generate().getFileLink();
            this.logger.debug("Printing " + title);
            response.setView(ActionView.define((String)title).add("html", fileLink).map());
        } else {
            response.setFlash(I18n.get((String)"Please select the Lead(s) to print."));
        }
    }

    public void showLeadsOnMap(ActionRequest request, ActionResponse response) {
        try {
            response.setView(ActionView.define((String)I18n.get((String)"Leads")).add("html", ((MapService)Beans.get(MapService.class)).getMapURI("lead")).map());
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)e);
        }
    }

    public void setSocialNetworkUrl(ActionRequest request, ActionResponse response) throws IOException {
        Lead lead = (Lead)((Object)request.getContext().asType(Lead.class));
        Map<String, String> urlMap = ((LeadService)Beans.get(LeadService.class)).getSocialNetworkUrl(lead.getName(), lead.getFirstName(), lead.getEnterpriseName());
        response.setAttr("googleLabel", "title", (Object)urlMap.get("google"));
        response.setAttr("facebookLabel", "title", (Object)urlMap.get("facebook"));
        response.setAttr("twitterLabel", "title", (Object)urlMap.get("twitter"));
        response.setAttr("linkedinLabel", "title", (Object)urlMap.get("linkedin"));
        response.setAttr("youtubeLabel", "title", (Object)urlMap.get("youtube"));
    }

    public void getLeadImportConfig(ActionRequest request, ActionResponse response) {
        ImportConfiguration leadImportConfig = (ImportConfiguration)((ImportConfigurationRepository)Beans.get(ImportConfigurationRepository.class)).all().filter("self.bindMetaFile.fileName = ?1", new Object[]{"import-lead-config.xml"}).fetchOne();
        this.logger.debug("ImportConfig for lead: {}", (Object)leadImportConfig);
        if (leadImportConfig == null) {
            response.setFlash(I18n.get((String)"No lead import configuration found"));
        } else {
            response.setView(ActionView.define((String)I18n.get((String)"Import lead")).model("com.axelor.apps.base.db.ImportConfiguration").add("form", "import-configuration-form").param("popup", "reload").param("forceEdit", "true").param("popup-save", "false").param("show-toolbar", "false").context("_showRecord", (Object)leadImportConfig.getId().toString()).map());
        }
    }

    public void checkLeadName(ActionRequest request, ActionResponse response) {
        Lead lead = (Lead)((Object)request.getContext().asType(Lead.class));
        response.setAttr("duplicateLeadText", "hidden", (Object)(!((LeadService)Beans.get(LeadService.class)).isThereDuplicateLead(lead) ? 1 : 0));
    }

    public void loseLead(ActionRequest request, ActionResponse response) {
        try {
            Lead lead = (Lead)((Object)request.getContext().asType(Lead.class));
            ((LeadService)Beans.get(LeadService.class)).loseLead((Lead)((Object)((LeadRepository)((Object)Beans.get(LeadRepository.class))).find(lead.getId())), lead.getLostReason());
            response.setCanClose(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }
}

