/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.Bank;
import com.axelor.apps.base.db.BankAddress;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.Partner;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.VirtualColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@DynamicInsert
@DynamicUpdate
@Table(name="BASE_BANK_DETAILS", indexes={@Index(columnList="partner"), @Index(columnList="bank"), @Index(columnList="bank_address"), @Index(columnList="currency"), @Index(columnList="fullName"), @Index(columnList="code")})
public class BankDetails
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_BANK_DETAILS_SEQ")
    @SequenceGenerator(name="BASE_BANK_DETAILS_SEQ", sequenceName="BASE_BANK_DETAILS_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Partner")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner partner;
    @Widget(title="Owner name")
    @Size(max=255)
    private String ownerName;
    @Widget(title="BIC (Bank Identifier)")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Bank bank;
    @Widget(title="SWIFT address")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private BankAddress bankAddress;
    @Widget(title="IBAN / BBAN")
    @NotNull
    private String iban;
    @Widget(title="Currency", massUpdate=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Currency currency;
    @Widget(title="Bank Code")
    @Size(max=255)
    private String bankCode;
    @Widget(title="Sort Code")
    @Size(max=255)
    private String sortCode;
    @Widget(title="Account Number")
    @Size(max=255)
    private String accountNbr;
    @Widget(title="BBan Key")
    @Size(max=255)
    private String bbanKey;
    @Widget(title="IBAN / BBAN + BIC")
    @Size(max=255)
    private String ibanBic;
    @Widget(title="Label")
    private String label;
    @Widget(title="Default")
    private Boolean isDefault = Boolean.FALSE;
    @Widget(title="Bank Details", search={"ownerName"})
    @NameColumn
    @VirtualColumn
    @Access(value=AccessType.PROPERTY)
    private String fullName;
    @Widget(title="Active", massUpdate=true)
    private Boolean active = Boolean.TRUE;
    private String code;
    @Widget(title="Specific note on invoice")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String specificNoteOnInvoice;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public BankDetails() {
    }

    public BankDetails(String code) {
        this.code = code;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Partner getPartner() {
        return this.partner;
    }

    public void setPartner(Partner partner) {
        this.partner = partner;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public Bank getBank() {
        return this.bank;
    }

    public void setBank(Bank bank) {
        this.bank = bank;
    }

    public BankAddress getBankAddress() {
        return this.bankAddress;
    }

    public void setBankAddress(BankAddress bankAddress) {
        this.bankAddress = bankAddress;
    }

    public String getIban() {
        return this.iban;
    }

    public void setIban(String iban) {
        this.iban = iban;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public String getBankCode() {
        return this.bankCode;
    }

    public void setBankCode(String bankCode) {
        this.bankCode = bankCode;
    }

    public String getSortCode() {
        return this.sortCode;
    }

    public void setSortCode(String sortCode) {
        this.sortCode = sortCode;
    }

    public String getAccountNbr() {
        return this.accountNbr;
    }

    public void setAccountNbr(String accountNbr) {
        this.accountNbr = accountNbr;
    }

    public String getBbanKey() {
        return this.bbanKey;
    }

    public void setBbanKey(String bbanKey) {
        this.bbanKey = bbanKey;
    }

    public String getIbanBic() {
        return this.ibanBic;
    }

    public void setIbanBic(String ibanBic) {
        this.ibanBic = ibanBic;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Boolean getIsDefault() {
        return this.isDefault == null ? Boolean.FALSE : this.isDefault;
    }

    public void setIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
    }

    public String getFullName() {
        try {
            this.fullName = this.computeFullName();
        }
        catch (NullPointerException e) {
            Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
            logger.error("NPE in function field: getFullName()", (Throwable)e);
        }
        return this.fullName;
    }

    protected String computeFullName() {
        String str = "";
        if (this.ownerName != null && !this.ownerName.isEmpty()) {
            str = this.ownerName;
            if (this.ibanBic != null && !this.ibanBic.isEmpty()) {
                str = str.concat(" - ").concat(this.ibanBic);
            } else if (this.iban != null && !this.iban.isEmpty()) {
                str = str.concat(" - ").concat(this.iban);
            } else if (!(this.bankCode == null || this.bankCode.isEmpty() || this.sortCode == null || this.sortCode.isEmpty() || this.accountNbr == null || this.accountNbr.isEmpty() || this.bbanKey == null || this.bbanKey.isEmpty())) {
                str = str.concat(" - ").concat(this.bankCode).concat(this.sortCode).concat(this.accountNbr).concat(this.bbanKey);
            }
            if (this.code != null && !this.code.isEmpty()) {
                str = str.concat(" - ").concat(this.code);
            }
        }
        return str;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public Boolean getActive() {
        return this.active == null ? Boolean.FALSE : this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getSpecificNoteOnInvoice() {
        return this.specificNoteOnInvoice;
    }

    public void setSpecificNoteOnInvoice(String specificNoteOnInvoice) {
        this.specificNoteOnInvoice = specificNoteOnInvoice;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BankDetails)) {
            return false;
        }
        BankDetails other = (BankDetails)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("ownerName", (Object)this.getOwnerName()).add("iban", (Object)this.getIban()).add("bankCode", (Object)this.getBankCode()).add("sortCode", (Object)this.getSortCode()).add("accountNbr", (Object)this.getAccountNbr()).add("bbanKey", (Object)this.getBbanKey()).add("ibanBic", (Object)this.getIbanBic()).add("label", (Object)this.getLabel()).add("isDefault", (Object)this.getIsDefault()).add("active", (Object)this.getActive()).add("code", (Object)this.getCode()).omitNullValues().toString();
    }
}

