/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.cash.management.db;

import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.cash.management.db.ForecastReason;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="MANAGEMENT_FORECAST_GENERATOR", indexes={@Index(columnList="company"), @Index(columnList="bank_details"), @Index(columnList="forecast_reason")})
public class ForecastGenerator
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="MANAGEMENT_FORECAST_GENERATOR_SEQ")
    @SequenceGenerator(name="MANAGEMENT_FORECAST_GENERATOR_SEQ", sequenceName="MANAGEMENT_FORECAST_GENERATOR_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Company")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Bank")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private BankDetails bankDetails;
    @Widget(title="Reason")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ForecastReason forecastReason;
    @Widget(title="Type", selection="iaccount.payment.mode.in.out.select")
    @NotNull
    private Integer typeSelect = 0;
    @Widget(title="Amount")
    private BigDecimal amount = BigDecimal.ZERO;
    @Widget(title="From")
    @NotNull
    private LocalDate fromDate;
    @Widget(title="To")
    @NotNull
    private LocalDate toDate;
    @Widget(title="Comments")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String comments;
    @Widget(title="Realized", selection="forecast.realized.select")
    private Integer realizedSelect = 2;
    @Widget(title="Periodicity", selection="product.periodicity.subscription.select")
    private Integer periodicitySelect = 1;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public BankDetails getBankDetails() {
        return this.bankDetails;
    }

    public void setBankDetails(BankDetails bankDetails) {
        this.bankDetails = bankDetails;
    }

    public ForecastReason getForecastReason() {
        return this.forecastReason;
    }

    public void setForecastReason(ForecastReason forecastReason) {
        this.forecastReason = forecastReason;
    }

    public Integer getTypeSelect() {
        return this.typeSelect == null ? 0 : this.typeSelect;
    }

    public void setTypeSelect(Integer typeSelect) {
        this.typeSelect = typeSelect;
    }

    public BigDecimal getAmount() {
        return this.amount == null ? BigDecimal.ZERO : this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public LocalDate getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(LocalDate fromDate) {
        this.fromDate = fromDate;
    }

    public LocalDate getToDate() {
        return this.toDate;
    }

    public void setToDate(LocalDate toDate) {
        this.toDate = toDate;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public Integer getRealizedSelect() {
        return this.realizedSelect == null ? 0 : this.realizedSelect;
    }

    public void setRealizedSelect(Integer realizedSelect) {
        this.realizedSelect = realizedSelect;
    }

    public Integer getPeriodicitySelect() {
        return this.periodicitySelect == null ? 0 : this.periodicitySelect;
    }

    public void setPeriodicitySelect(Integer periodicitySelect) {
        this.periodicitySelect = periodicitySelect;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ForecastGenerator)) {
            return false;
        }
        ForecastGenerator other = (ForecastGenerator)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("typeSelect", (Object)this.getTypeSelect()).add("amount", (Object)this.getAmount()).add("fromDate", (Object)this.getFromDate()).add("toDate", (Object)this.getToDate()).add("realizedSelect", (Object)this.getRealizedSelect()).add("periodicitySelect", (Object)this.getPeriodicitySelect()).omitNullValues().toString();
    }
}

