/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.cash.management.db;

import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.cash.management.db.ForecastRecapLine;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="MANAGEMENT_FORECAST_RECAP", uniqueConstraints={@UniqueConstraint(columnNames={"forecastRecapSeq", "company"})}, indexes={@Index(columnList="company"), @Index(columnList="bank_details"), @Index(columnList="currency"), @Index(columnList="sales_man")})
public class ForecastRecap
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="MANAGEMENT_FORECAST_RECAP_SEQ")
    @SequenceGenerator(name="MANAGEMENT_FORECAST_RECAP_SEQ", sequenceName="MANAGEMENT_FORECAST_RECAP_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Seq.", readonly=true)
    private String forecastRecapSeq;
    @Widget(title="Company")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Bank")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private BankDetails bankDetails;
    @Widget(title="Starting Balance")
    @NotNull
    private BigDecimal startingBalance = BigDecimal.ZERO;
    @Widget(title="Ending Balance")
    private BigDecimal endingBalance = BigDecimal.ZERO;
    private BigDecimal currentBalance = BigDecimal.ZERO;
    @Widget(title="From")
    private LocalDate fromDate;
    @Widget(title="To")
    private LocalDate toDate;
    @Widget(title="Details")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="forecastRecap", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ForecastRecapLine> forecastRecapLineList;
    @Widget(title="Take into account opportunies", selection="forecast.opportunities.type.select")
    private Integer opportunitiesTypeSelect = 0;
    @Widget(title="Currency", massUpdate=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Currency currency;
    @Widget(title="SalesMan")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User salesMan;
    @Widget(title="Display", selection="display.type.select")
    private Integer displayTypeSelect = 3;
    private Boolean isReport = Boolean.FALSE;
    @Widget(title="Calculation Date", readonly=true)
    private LocalDate calculationDate;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getForecastRecapSeq() {
        return this.forecastRecapSeq;
    }

    public void setForecastRecapSeq(String forecastRecapSeq) {
        this.forecastRecapSeq = forecastRecapSeq;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public BankDetails getBankDetails() {
        return this.bankDetails;
    }

    public void setBankDetails(BankDetails bankDetails) {
        this.bankDetails = bankDetails;
    }

    public BigDecimal getStartingBalance() {
        return this.startingBalance == null ? BigDecimal.ZERO : this.startingBalance;
    }

    public void setStartingBalance(BigDecimal startingBalance) {
        this.startingBalance = startingBalance;
    }

    public BigDecimal getEndingBalance() {
        return this.endingBalance == null ? BigDecimal.ZERO : this.endingBalance;
    }

    public void setEndingBalance(BigDecimal endingBalance) {
        this.endingBalance = endingBalance;
    }

    public BigDecimal getCurrentBalance() {
        return this.currentBalance == null ? BigDecimal.ZERO : this.currentBalance;
    }

    public void setCurrentBalance(BigDecimal currentBalance) {
        this.currentBalance = currentBalance;
    }

    public LocalDate getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(LocalDate fromDate) {
        this.fromDate = fromDate;
    }

    public LocalDate getToDate() {
        return this.toDate;
    }

    public void setToDate(LocalDate toDate) {
        this.toDate = toDate;
    }

    public List<ForecastRecapLine> getForecastRecapLineList() {
        return this.forecastRecapLineList;
    }

    public void setForecastRecapLineList(List<ForecastRecapLine> forecastRecapLineList) {
        this.forecastRecapLineList = forecastRecapLineList;
    }

    public void addForecastRecapLineListItem(ForecastRecapLine item) {
        if (this.getForecastRecapLineList() == null) {
            this.setForecastRecapLineList(new ArrayList<ForecastRecapLine>());
        }
        this.getForecastRecapLineList().add(item);
        item.setForecastRecap(this);
    }

    public void removeForecastRecapLineListItem(ForecastRecapLine item) {
        if (this.getForecastRecapLineList() == null) {
            return;
        }
        this.getForecastRecapLineList().remove((Object)item);
    }

    public void clearForecastRecapLineList() {
        if (this.getForecastRecapLineList() != null) {
            this.getForecastRecapLineList().clear();
        }
    }

    public Integer getOpportunitiesTypeSelect() {
        return this.opportunitiesTypeSelect == null ? 0 : this.opportunitiesTypeSelect;
    }

    public void setOpportunitiesTypeSelect(Integer opportunitiesTypeSelect) {
        this.opportunitiesTypeSelect = opportunitiesTypeSelect;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public User getSalesMan() {
        return this.salesMan;
    }

    public void setSalesMan(User salesMan) {
        this.salesMan = salesMan;
    }

    public Integer getDisplayTypeSelect() {
        return this.displayTypeSelect == null ? 0 : this.displayTypeSelect;
    }

    public void setDisplayTypeSelect(Integer displayTypeSelect) {
        this.displayTypeSelect = displayTypeSelect;
    }

    public Boolean getIsReport() {
        return this.isReport == null ? Boolean.FALSE : this.isReport;
    }

    public void setIsReport(Boolean isReport) {
        this.isReport = isReport;
    }

    public LocalDate getCalculationDate() {
        return this.calculationDate;
    }

    public void setCalculationDate(LocalDate calculationDate) {
        this.calculationDate = calculationDate;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ForecastRecap)) {
            return false;
        }
        ForecastRecap other = (ForecastRecap)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("forecastRecapSeq", (Object)this.getForecastRecapSeq()).add("startingBalance", (Object)this.getStartingBalance()).add("endingBalance", (Object)this.getEndingBalance()).add("currentBalance", (Object)this.getCurrentBalance()).add("fromDate", (Object)this.getFromDate()).add("toDate", (Object)this.getToDate()).add("opportunitiesTypeSelect", (Object)this.getOpportunitiesTypeSelect()).add("displayTypeSelect", (Object)this.getDisplayTypeSelect()).add("isReport", (Object)this.getIsReport()).add("calculationDate", (Object)this.getCalculationDate()).omitNullValues().toString();
    }
}

