/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.cash.management.db.repo;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.service.administration.SequenceService;
import com.axelor.apps.cash.management.db.ForecastRecap;
import com.axelor.apps.cash.management.db.repo.ForecastRecapRepository;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import java.math.BigDecimal;
import javax.persistence.PersistenceException;

public class CashManagementForecastRecapRepository
extends ForecastRecapRepository {
    public ForecastRecap save(ForecastRecap entity) {
        try {
            if (entity.getForecastRecapSeq() == null) {
                Company company = entity.getCompany();
                String sequence = ((SequenceService)Beans.get(SequenceService.class)).getSequenceNumber("forecastRecap", company);
                if (sequence == null) {
                    throw new AxelorException((Model)((Object)company), 4, I18n.get((String)"The company %s doesn't have any configured sequence for ForcastRecap"), new Object[]{company.getName()});
                }
                entity.setForecastRecapSeq(sequence);
            }
            return (ForecastRecap)((Object)super.save((Model)((Object)entity)));
        }
        catch (AxelorException e) {
            throw new PersistenceException(e.getLocalizedMessage());
        }
    }

    public ForecastRecap copy(ForecastRecap entity, boolean deep) {
        ForecastRecap copy = (ForecastRecap)((Object)super.copy((Model)((Object)entity), deep));
        copy.clearForecastRecapLineList();
        copy.setCalculationDate(null);
        copy.setForecastRecapSeq(null);
        copy.setEndingBalance(BigDecimal.ZERO);
        return copy;
    }
}

