/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.cash.management.service;

import com.axelor.apps.ReportFactory;
import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.repo.InvoiceRepository;
import com.axelor.apps.base.service.CurrencyService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.cash.management.db.Forecast;
import com.axelor.apps.cash.management.db.ForecastReason;
import com.axelor.apps.cash.management.db.ForecastRecap;
import com.axelor.apps.cash.management.db.ForecastRecapLine;
import com.axelor.apps.cash.management.db.repo.ForecastRecapLineRepository;
import com.axelor.apps.cash.management.db.repo.ForecastRecapRepository;
import com.axelor.apps.cash.management.db.repo.ForecastRepository;
import com.axelor.apps.crm.db.Opportunity;
import com.axelor.apps.crm.db.repo.OpportunityRepository;
import com.axelor.apps.hr.db.Employee;
import com.axelor.apps.hr.db.Expense;
import com.axelor.apps.hr.db.repo.EmployeeRepository;
import com.axelor.apps.hr.db.repo.ExpenseRepository;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.purchase.db.repo.PurchaseOrderRepository;
import com.axelor.apps.report.engine.ReportSettings;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.repo.SaleOrderRepository;
import com.axelor.apps.supplychain.db.Timetable;
import com.axelor.apps.supplychain.db.repo.TimetableRepository;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ForecastRecapService {
    private final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Inject
    protected AppBaseService appBaseService;
    @Inject
    protected ForecastRepository forecastRepo;
    @Inject
    protected ForecastRecapLineRepository forecastRecapLineRepo;
    @Inject
    protected CurrencyService currencyService;

    @Transactional
    public void populate(ForecastRecap forecastRecap) throws AxelorException {
        List<ForecastRecapLine> forecastRecapLineList = forecastRecap.getForecastRecapLineList();
        if (forecastRecapLineList != null && !forecastRecapLineList.isEmpty()) {
            for (ForecastRecapLine forecastRecapLine : forecastRecapLineList) {
                if (forecastRecapLine.getId() == null || forecastRecapLine.getId() <= 0L) continue;
                this.forecastRecapLineRepo.remove((Model)((Object)forecastRecapLine));
            }
            forecastRecapLineList.clear();
        }
        forecastRecap.setCurrentBalance(forecastRecap.getStartingBalance());
        if (forecastRecap.getOpportunitiesTypeSelect() != null && forecastRecap.getOpportunitiesTypeSelect() > 1) {
            this.populateWithOpportunities(forecastRecap);
        }
        this.populateWithInvoices(forecastRecap);
        this.populateWithSalaries(forecastRecap);
        this.populateWithTimetables(forecastRecap);
        this.populateWithForecasts(forecastRecap);
        this.populateWithExpenses(forecastRecap);
        this.computeForecastRecapLineBalance(forecastRecap);
        forecastRecap.setEndingBalance(forecastRecap.getCurrentBalance());
        forecastRecap.setCalculationDate(this.appBaseService.getTodayDate());
        ((ForecastRecapRepository)((Object)Beans.get(ForecastRecapRepository.class))).save((Model)((Object)forecastRecap));
    }

    public void populateWithOpportunities(ForecastRecap forecastRecap) throws AxelorException {
        List opportunityList = new ArrayList();
        opportunityList = forecastRecap.getBankDetails() != null ? ((OpportunityRepository)((Object)Beans.get(OpportunityRepository.class))).all().filter("self.company = ?1 AND self.bankDetails = ?2 AND self.expectedCloseDate BETWEEN ?3 AND ?4 AND self.saleOrderList IS EMPTY", new Object[]{forecastRecap.getCompany(), forecastRecap.getBankDetails(), forecastRecap.getFromDate(), forecastRecap.getToDate()}).fetch() : ((OpportunityRepository)((Object)Beans.get(OpportunityRepository.class))).all().filter("self.company = ?1 AND self.expectedCloseDate BETWEEN ?2 AND ?3 AND self.saleOrderList IS EMPTY", new Object[]{forecastRecap.getCompany(), forecastRecap.getFromDate(), forecastRecap.getToDate()}).fetch();
        for (Opportunity opportunity : opportunityList) {
            BigDecimal amountCompanyCurr = BigDecimal.ZERO;
            if (forecastRecap.getOpportunitiesTypeSelect() == 2) {
                amountCompanyCurr = this.currencyService.getAmountCurrencyConvertedAtDate(opportunity.getCurrency(), opportunity.getCompany().getCurrency(), opportunity.getAmount().multiply(opportunity.getProbability()).divide(new BigDecimal(100), 2, RoundingMode.HALF_UP), this.appBaseService.getTodayDate()).setScale(2, RoundingMode.HALF_UP);
                forecastRecap.addForecastRecapLineListItem(this.createForecastRecapLine(opportunity.getExpectedCloseDate(), 1, amountCompanyCurr, null, null, null));
                continue;
            }
            if (forecastRecap.getOpportunitiesTypeSelect() == 4) {
                amountCompanyCurr = this.currencyService.getAmountCurrencyConvertedAtDate(opportunity.getCurrency(), opportunity.getCompany().getCurrency(), new BigDecimal(opportunity.getBestCase()).multiply(opportunity.getProbability()).divide(new BigDecimal(100), 2, RoundingMode.HALF_UP), this.appBaseService.getTodayDate()).setScale(2, RoundingMode.HALF_UP);
                forecastRecap.addForecastRecapLineListItem(this.createForecastRecapLine(opportunity.getExpectedCloseDate(), 1, amountCompanyCurr, null, null, null));
                continue;
            }
            amountCompanyCurr = this.currencyService.getAmountCurrencyConvertedAtDate(opportunity.getCurrency(), opportunity.getCompany().getCurrency(), new BigDecimal(opportunity.getWorstCase()).multiply(opportunity.getProbability()).divide(new BigDecimal(100), 2, RoundingMode.HALF_UP), this.appBaseService.getTodayDate()).setScale(2, RoundingMode.HALF_UP);
            forecastRecap.addForecastRecapLineListItem(this.createForecastRecapLine(opportunity.getExpectedCloseDate(), 1, amountCompanyCurr, null, null, null));
        }
    }

    public void getOpportunities(ForecastRecap forecastRecap, Map<LocalDate, BigDecimal> mapExpected, Map<LocalDate, BigDecimal> mapConfirmed) throws AxelorException {
        List opportunityList = new ArrayList();
        opportunityList = forecastRecap.getBankDetails() != null ? ((OpportunityRepository)((Object)Beans.get(OpportunityRepository.class))).all().filter("self.company = ?1 AND self.bankDetails = ?2 AND self.expectedCloseDate BETWEEN ?3 AND ?4 AND self.saleOrderList IS EMPTY", new Object[]{forecastRecap.getCompany(), forecastRecap.getBankDetails(), forecastRecap.getFromDate(), forecastRecap.getToDate()}).fetch() : ((OpportunityRepository)((Object)Beans.get(OpportunityRepository.class))).all().filter("self.company = ?1 AND self.expectedCloseDate BETWEEN ?2 AND ?3 AND self.saleOrderList IS EMPTY", new Object[]{forecastRecap.getCompany(), forecastRecap.getFromDate(), forecastRecap.getToDate()}).fetch();
        for (Opportunity opportunity : opportunityList) {
            BigDecimal amountCompanyCurr = BigDecimal.ZERO;
            amountCompanyCurr = forecastRecap.getOpportunitiesTypeSelect() == 2 ? this.currencyService.getAmountCurrencyConvertedAtDate(opportunity.getCurrency(), opportunity.getCompany().getCurrency(), opportunity.getAmount().multiply(opportunity.getProbability()).divide(new BigDecimal(100), 2, RoundingMode.HALF_UP), this.appBaseService.getTodayDate()).setScale(2, RoundingMode.HALF_UP) : (forecastRecap.getOpportunitiesTypeSelect() == 4 ? this.currencyService.getAmountCurrencyConvertedAtDate(opportunity.getCurrency(), opportunity.getCompany().getCurrency(), new BigDecimal(opportunity.getBestCase()).multiply(opportunity.getProbability()).divide(new BigDecimal(100), 2, RoundingMode.HALF_UP), this.appBaseService.getTodayDate()).setScale(2, RoundingMode.HALF_UP) : this.currencyService.getAmountCurrencyConvertedAtDate(opportunity.getCurrency(), opportunity.getCompany().getCurrency(), new BigDecimal(opportunity.getWorstCase()).multiply(opportunity.getProbability()).divide(new BigDecimal(100), 2, RoundingMode.HALF_UP), this.appBaseService.getTodayDate()).setScale(2, RoundingMode.HALF_UP));
            if (opportunity.getSalesStageSelect() == 9) {
                if (mapExpected.containsKey(opportunity.getExpectedCloseDate())) {
                    mapExpected.put(opportunity.getExpectedCloseDate(), mapExpected.get(opportunity.getExpectedCloseDate()).add(amountCompanyCurr));
                    continue;
                }
                mapExpected.put(opportunity.getExpectedCloseDate(), amountCompanyCurr);
                continue;
            }
            if (mapConfirmed.containsKey(opportunity.getExpectedCloseDate())) {
                mapConfirmed.put(opportunity.getExpectedCloseDate(), mapConfirmed.get(opportunity.getExpectedCloseDate()).add(amountCompanyCurr));
                continue;
            }
            mapConfirmed.put(opportunity.getExpectedCloseDate(), amountCompanyCurr);
        }
    }

    public void populateWithInvoices(ForecastRecap forecastRecap) {
        List invoiceList = new ArrayList();
        invoiceList = forecastRecap.getBankDetails() != null ? ((InvoiceRepository)((Object)Beans.get(InvoiceRepository.class))).all().filter("self.company = ?1 AND self.companyBankDetails = ?2 AND self.statusSelect = 3 AND self.estimatedPaymentDate BETWEEN ?3 AND ?4 AND self.companyInTaxTotalRemaining != 0", new Object[]{forecastRecap.getCompany(), forecastRecap.getBankDetails(), forecastRecap.getFromDate(), forecastRecap.getToDate()}).fetch() : ((InvoiceRepository)((Object)Beans.get(InvoiceRepository.class))).all().filter("self.company = ?1 AND self.statusSelect = 3 AND self.estimatedPaymentDate BETWEEN ?2 AND ?3 AND self.companyInTaxTotalRemaining != 0", new Object[]{forecastRecap.getCompany(), forecastRecap.getFromDate(), forecastRecap.getToDate()}).fetch();
        for (Invoice invoice : invoiceList) {
            BigDecimal amountPaidExTax = invoice.getAmountPaid().multiply(invoice.getCompanyExTaxTotal()).divide(invoice.getCompanyInTaxTotal(), 2, RoundingMode.HALF_UP);
            BigDecimal amount = invoice.getCompanyExTaxTotal().subtract(amountPaidExTax);
            if (invoice.getOperationTypeSelect() == 2 || invoice.getOperationTypeSelect() == 3) {
                forecastRecap.addForecastRecapLineListItem(this.createForecastRecapLine(invoice.getEstimatedPaymentDate(), 1, amount, Invoice.class.getName(), invoice.getId(), invoice.getInvoiceId()));
            }
            if (invoice.getOperationTypeSelect() != 1 && invoice.getOperationTypeSelect() != 4) continue;
            forecastRecap.addForecastRecapLineListItem(this.createForecastRecapLine(invoice.getEstimatedPaymentDate(), 2, amount, Invoice.class.getName(), invoice.getId(), invoice.getInvoiceId()));
        }
    }

    public void getInvoices(ForecastRecap forecastRecap, Map<LocalDate, BigDecimal> mapExpected, Map<LocalDate, BigDecimal> mapConfirmed) {
        List invoiceList = new ArrayList();
        invoiceList = forecastRecap.getBankDetails() != null ? ((InvoiceRepository)((Object)Beans.get(InvoiceRepository.class))).all().filter("self.company = ?1 AND self.companyBankDetails = ?2 AND self.statusSelect = 3 AND self.estimatedPaymentDate BETWEEN ?3 AND ?4 AND self.companyInTaxTotalRemaining != 0", new Object[]{forecastRecap.getCompany(), forecastRecap.getBankDetails(), forecastRecap.getFromDate(), forecastRecap.getToDate()}).fetch() : ((InvoiceRepository)((Object)Beans.get(InvoiceRepository.class))).all().filter("self.company = ?1 AND self.statusSelect = 3 AND self.estimatedPaymentDate BETWEEN ?2 AND ?3 AND self.companyInTaxTotalRemaining != 0", new Object[]{forecastRecap.getCompany(), forecastRecap.getFromDate(), forecastRecap.getToDate()}).fetch();
        for (Invoice invoice : invoiceList) {
            BigDecimal amountPaidExTax = invoice.getAmountPaid().multiply(invoice.getCompanyExTaxTotal()).divide(invoice.getCompanyInTaxTotal(), 2, RoundingMode.HALF_UP);
            BigDecimal amount = invoice.getCompanyExTaxTotal().subtract(amountPaidExTax);
            if (invoice.getOperationTypeSelect() != 2 && invoice.getOperationTypeSelect() != 3) continue;
            if (mapConfirmed.containsKey(invoice.getEstimatedPaymentDate())) {
                mapConfirmed.put(invoice.getEstimatedPaymentDate(), mapConfirmed.get(invoice.getEstimatedPaymentDate()).add(amount));
                continue;
            }
            mapConfirmed.put(invoice.getEstimatedPaymentDate(), amount);
        }
    }

    public void populateWithSalaries(ForecastRecap forecastRecap) {
        List employeeList = new ArrayList();
        employeeList = forecastRecap.getBankDetails() != null ? ((EmployeeRepository)((Object)Beans.get(EmployeeRepository.class))).all().filter("self.mainEmploymentContract.payCompany = ?1 AND self.bankDetails = ?2", new Object[]{forecastRecap.getCompany(), forecastRecap.getBankDetails()}).fetch() : ((EmployeeRepository)((Object)Beans.get(EmployeeRepository.class))).all().filter("self.mainEmploymentContract.payCompany = ?1", new Object[]{forecastRecap.getCompany()}).fetch();
        LocalDate itDate = LocalDate.parse(forecastRecap.getFromDate().toString(), DateTimeFormatter.ISO_DATE);
        while (!itDate.isAfter(forecastRecap.getToDate())) {
            LocalDate monthEnd = itDate.withDayOfMonth(itDate.lengthOfMonth());
            if (itDate.isEqual(monthEnd)) {
                for (Employee employee : employeeList) {
                    forecastRecap.addForecastRecapLineListItem(this.createForecastRecapLine(itDate, 2, employee.getHourlyRate().multiply(employee.getWeeklyWorkHours().multiply(new BigDecimal(4))), null, null, null));
                }
                itDate = itDate.plusMonths(1L);
                continue;
            }
            itDate = monthEnd;
        }
    }

    public void populateWithTimetables(ForecastRecap forecastRecap) throws AxelorException {
        BigDecimal amountCompanyCurr;
        List timetableSaleOrderList = new ArrayList();
        List timetablePurchaseOrderList = new ArrayList();
        if (forecastRecap.getBankDetails() != null) {
            timetableSaleOrderList = ((TimetableRepository)Beans.get(TimetableRepository.class)).all().filter("self.estimatedDate BETWEEN ?1 AND ?2 AND self.saleOrder.company = ?3 AND self.saleOrder.companyBankDetails = ?4 AND self.saleOrder.statusSelect = 3 AND self.amount != 0", new Object[]{forecastRecap.getFromDate(), forecastRecap.getToDate(), forecastRecap.getCompany(), forecastRecap.getBankDetails()}).fetch();
            timetablePurchaseOrderList = ((TimetableRepository)Beans.get(TimetableRepository.class)).all().filter("self.estimatedDate BETWEEN ?1 AND ?2 AND self.purchaseOrder.company = ?3 AND self.purchaseOrder.companyBankDetails = ?4 AND self.purchaseOrder.statusSelect = 3 AND self.amount != 0", new Object[]{forecastRecap.getFromDate(), forecastRecap.getToDate(), forecastRecap.getCompany(), forecastRecap.getBankDetails()}).fetch();
        } else {
            timetableSaleOrderList = ((TimetableRepository)Beans.get(TimetableRepository.class)).all().filter("self.estimatedDate BETWEEN ?1 AND ?2 AND self.saleOrder.company = ?3 AND self.saleOrder.statusSelect = 3 AND self.amount != 0", new Object[]{forecastRecap.getFromDate(), forecastRecap.getToDate(), forecastRecap.getCompany()}).fetch();
            timetablePurchaseOrderList = ((TimetableRepository)Beans.get(TimetableRepository.class)).all().filter("self.estimatedDate BETWEEN ?1 AND ?2 AND self.purchaseOrder.company = ?3 AND self.purchaseOrder.statusSelect = 3 AND self.amount != 0", new Object[]{forecastRecap.getFromDate(), forecastRecap.getToDate(), forecastRecap.getCompany()}).fetch();
        }
        for (Timetable timetable : timetableSaleOrderList) {
            amountCompanyCurr = this.currencyService.getAmountCurrencyConvertedAtDate(timetable.getSaleOrder().getCurrency(), timetable.getSaleOrder().getCompany().getCurrency(), timetable.getAmount(), this.appBaseService.getTodayDate()).setScale(2, RoundingMode.HALF_UP);
            forecastRecap.addForecastRecapLineListItem(this.createForecastRecapLine(timetable.getEstimatedDate(), 1, amountCompanyCurr, null, null, null));
        }
        for (Timetable timetable : timetablePurchaseOrderList) {
            amountCompanyCurr = this.currencyService.getAmountCurrencyConvertedAtDate(timetable.getPurchaseOrder().getCurrency(), timetable.getPurchaseOrder().getCompany().getCurrency(), timetable.getAmount(), this.appBaseService.getTodayDate()).setScale(2, RoundingMode.HALF_UP);
            forecastRecap.addForecastRecapLineListItem(this.createForecastRecapLine(timetable.getEstimatedDate(), 2, amountCompanyCurr, null, null, null));
        }
    }

    public void populateWithTimetablesOrOrders(ForecastRecap forecastRecap) throws AxelorException {
        BigDecimal amountCompanyCurr;
        BigDecimal amountCompanyCurr2;
        List timetableSaleOrderList = new ArrayList();
        ArrayList<SaleOrder> saleOrderList = new ArrayList<SaleOrder>();
        List timetablePurchaseOrderList = new ArrayList();
        ArrayList<PurchaseOrder> purchaseOrderList = new ArrayList<PurchaseOrder>();
        if (forecastRecap.getBankDetails() != null) {
            timetableSaleOrderList = ((TimetableRepository)Beans.get(TimetableRepository.class)).all().filter("self.estimatedDate BETWEEN ?1 AND ?2 AND self.saleOrder.company = ?3 AND self.saleOrder.companyBankDetails = ?4 AND self.saleOrder.statusSelect = 3 AND self.amount != 0", new Object[]{forecastRecap.getFromDate(), forecastRecap.getToDate(), forecastRecap.getCompany(), forecastRecap.getBankDetails()}).fetch();
            timetablePurchaseOrderList = ((TimetableRepository)Beans.get(TimetableRepository.class)).all().filter("self.estimatedDate BETWEEN ?1 AND ?2 AND self.purchaseOrder.company = ?3 AND self.purchaseOrder.companyBankDetails = ?4 AND self.purchaseOrder.statusSelect = 3 AND self.amount != 0", new Object[]{forecastRecap.getFromDate(), forecastRecap.getToDate(), forecastRecap.getCompany(), forecastRecap.getBankDetails()}).fetch();
        } else {
            timetableSaleOrderList = ((TimetableRepository)Beans.get(TimetableRepository.class)).all().filter("self.estimatedDate BETWEEN ?1 AND ?2 AND self.saleOrder.company = ?3 AND self.saleOrder.statusSelect = 3 AND self.amount != 0", new Object[]{forecastRecap.getFromDate(), forecastRecap.getToDate(), forecastRecap.getCompany()}).fetch();
            timetablePurchaseOrderList = ((TimetableRepository)Beans.get(TimetableRepository.class)).all().filter("self.estimatedDate BETWEEN ?1 AND ?2 AND self.purchaseOrder.company = ?3 AND self.purchaseOrder.statusSelect = 3 AND self.amount != 0", new Object[]{forecastRecap.getFromDate(), forecastRecap.getToDate(), forecastRecap.getCompany()}).fetch();
        }
        for (Timetable timetable : timetableSaleOrderList) {
            saleOrderList.add(timetable.getSaleOrder());
            amountCompanyCurr2 = this.currencyService.getAmountCurrencyConvertedAtDate(timetable.getSaleOrder().getCurrency(), timetable.getSaleOrder().getCompany().getCurrency(), timetable.getAmount(), this.appBaseService.getTodayDate()).setScale(2, RoundingMode.HALF_UP);
            forecastRecap.addForecastRecapLineListItem(this.createForecastRecapLine(timetable.getEstimatedDate(), 1, amountCompanyCurr2, null, null, null));
        }
        for (Timetable timetable : timetablePurchaseOrderList) {
            purchaseOrderList.add(timetable.getPurchaseOrder());
            amountCompanyCurr2 = this.currencyService.getAmountCurrencyConvertedAtDate(timetable.getPurchaseOrder().getCurrency(), timetable.getPurchaseOrder().getCompany().getCurrency(), timetable.getAmount(), this.appBaseService.getTodayDate()).setScale(2, RoundingMode.HALF_UP);
            forecastRecap.addForecastRecapLineListItem(this.createForecastRecapLine(timetable.getEstimatedDate(), 2, amountCompanyCurr2, null, null, null));
        }
        List saleOrderNoTimeTableList = new ArrayList();
        List purchaseOrderNoTimetableList = new ArrayList();
        if (forecastRecap.getBankDetails() != null) {
            saleOrderNoTimeTableList = ((SaleOrderRepository)((Object)Beans.get(SaleOrderRepository.class))).all().filter("self.expectedRealisationDate BETWEEN ?1 AND ?2 AND self.company = ?3 AND self.companyBankDetails = ?4 AND (self.statusSelect = 2 OR self.statusSelect = 3)", new Object[]{forecastRecap.getFromDate(), forecastRecap.getToDate(), forecastRecap.getCompany(), forecastRecap.getBankDetails()}).fetch();
            purchaseOrderNoTimetableList = ((PurchaseOrderRepository)((Object)Beans.get(PurchaseOrderRepository.class))).all().filter("self.expectedRealisationDate BETWEEN ?1 AND ?2 AND self.company = ?3 AND self.companyBankDetails = ?4 AND self.statusSelect = 3", new Object[]{forecastRecap.getFromDate(), forecastRecap.getToDate(), forecastRecap.getCompany(), forecastRecap.getBankDetails()}).fetch();
        } else {
            saleOrderNoTimeTableList = ((SaleOrderRepository)((Object)Beans.get(SaleOrderRepository.class))).all().filter("self.expectedRealisationDate BETWEEN ?1 AND ?2 AND self.company = ?3 AND (self.statusSelect = 2 OR self.statusSelect = 3)", new Object[]{forecastRecap.getFromDate(), forecastRecap.getToDate(), forecastRecap.getCompany()}).fetch();
            purchaseOrderNoTimetableList = ((PurchaseOrderRepository)((Object)Beans.get(PurchaseOrderRepository.class))).all().filter("self.expectedRealisationDate BETWEEN ?1 AND ?2 AND self.company = ?3 AND self.statusSelect = 3", new Object[]{forecastRecap.getFromDate(), forecastRecap.getToDate(), forecastRecap.getCompany()}).fetch();
        }
        for (SaleOrder saleOrder : saleOrderNoTimeTableList) {
            if (saleOrderList.contains((Object)saleOrder) || (amountCompanyCurr = saleOrder.getCompanyExTaxTotal().subtract(saleOrder.getAmountInvoiced())).compareTo(BigDecimal.ZERO) != 0) continue;
            forecastRecap.addForecastRecapLineListItem(this.createForecastRecapLine(saleOrder.getExpectedRealisationDate(), 1, amountCompanyCurr, SaleOrder.class.getName(), saleOrder.getId(), saleOrder.getSaleOrderSeq()));
        }
        for (PurchaseOrder purchaseOrder : purchaseOrderNoTimetableList) {
            if (purchaseOrderList.contains((Object)purchaseOrder) || (amountCompanyCurr = purchaseOrder.getCompanyExTaxTotal().subtract(purchaseOrder.getAmountInvoiced())).compareTo(BigDecimal.ZERO) != 0) continue;
            forecastRecap.addForecastRecapLineListItem(this.createForecastRecapLine(purchaseOrder.getExpectedRealisationDate(), 2, amountCompanyCurr, PurchaseOrder.class.getName(), purchaseOrder.getId(), purchaseOrder.getPurchaseOrderSeq()));
        }
    }

    public void getTimetablesOrOrders(ForecastRecap forecastRecap, Map<LocalDate, BigDecimal> mapExpected, Map<LocalDate, BigDecimal> mapConfirmed) throws AxelorException {
        List timetableSaleOrderList = new ArrayList();
        ArrayList<SaleOrder> saleOrderList = new ArrayList<SaleOrder>();
        timetableSaleOrderList = forecastRecap.getBankDetails() != null ? ((TimetableRepository)Beans.get(TimetableRepository.class)).all().filter("self.estimatedDate BETWEEN ?1 AND ?2 AND self.saleOrder.company = ?3 AND self.saleOrder.companyBankDetails = ?4 AND (self.saleOrder.statusSelect = 2 OR self.saleOrder.statusSelect = 3) AND self.amount != 0", new Object[]{forecastRecap.getFromDate(), forecastRecap.getToDate(), forecastRecap.getCompany(), forecastRecap.getBankDetails()}).fetch() : ((TimetableRepository)Beans.get(TimetableRepository.class)).all().filter("self.estimatedDate BETWEEN ?1 AND ?2 AND self.saleOrder.company = ?3 AND (self.saleOrder.statusSelect = 2 OR self.saleOrder.statusSelect = 3) AND self.amount != 0", new Object[]{forecastRecap.getFromDate(), forecastRecap.getToDate(), forecastRecap.getCompany()}).fetch();
        for (Timetable timetable : timetableSaleOrderList) {
            saleOrderList.add(timetable.getSaleOrder());
            BigDecimal amountCompanyCurr = this.currencyService.getAmountCurrencyConvertedAtDate(timetable.getSaleOrder().getCurrency(), timetable.getSaleOrder().getCompany().getCurrency(), timetable.getAmount(), this.appBaseService.getTodayDate()).setScale(2, RoundingMode.HALF_UP);
            if (timetable.getSaleOrder().getStatusSelect() == 2) {
                if (mapExpected.containsKey(timetable.getEstimatedDate())) {
                    mapExpected.put(timetable.getEstimatedDate(), mapExpected.get(timetable.getEstimatedDate()).add(amountCompanyCurr));
                    continue;
                }
                mapExpected.put(timetable.getEstimatedDate(), amountCompanyCurr);
                continue;
            }
            if (mapConfirmed.containsKey(timetable.getEstimatedDate())) {
                mapConfirmed.put(timetable.getEstimatedDate(), mapConfirmed.get(timetable.getEstimatedDate()).add(amountCompanyCurr));
                continue;
            }
            mapConfirmed.put(timetable.getEstimatedDate(), amountCompanyCurr);
        }
        List saleOrderNoTimeTableList = new ArrayList();
        saleOrderNoTimeTableList = forecastRecap.getBankDetails() != null ? ((SaleOrderRepository)((Object)Beans.get(SaleOrderRepository.class))).all().filter("self.expectedRealisationDate BETWEEN ?1 AND ?2 AND self.company = ?3 AND self.companyBankDetails = ?4 AND (self.statusSelect = 2 OR self.statusSelect = 3)", new Object[]{forecastRecap.getFromDate(), forecastRecap.getToDate(), forecastRecap.getCompany(), forecastRecap.getBankDetails()}).fetch() : ((SaleOrderRepository)((Object)Beans.get(SaleOrderRepository.class))).all().filter("self.expectedRealisationDate BETWEEN ?1 AND ?2 AND self.company = ?3 AND (self.statusSelect = 2 OR self.statusSelect = 3)", new Object[]{forecastRecap.getFromDate(), forecastRecap.getToDate(), forecastRecap.getCompany()}).fetch();
        for (SaleOrder saleOrder : saleOrderNoTimeTableList) {
            BigDecimal amountCompanyCurr;
            if (saleOrderList.contains((Object)saleOrder) || (amountCompanyCurr = saleOrder.getCompanyExTaxTotal().subtract(saleOrder.getAmountInvoiced())).compareTo(BigDecimal.ZERO) != 0) continue;
            if (saleOrder.getStatusSelect() == 2) {
                if (mapExpected.containsKey(saleOrder.getExpectedRealisationDate())) {
                    mapExpected.put(saleOrder.getExpectedRealisationDate(), mapExpected.get(saleOrder.getExpectedRealisationDate()).add(amountCompanyCurr));
                    continue;
                }
                mapExpected.put(saleOrder.getExpectedRealisationDate(), amountCompanyCurr);
                continue;
            }
            if (mapConfirmed.containsKey(saleOrder.getExpectedRealisationDate())) {
                mapConfirmed.put(saleOrder.getExpectedRealisationDate(), mapConfirmed.get(saleOrder.getExpectedRealisationDate()).add(amountCompanyCurr));
                continue;
            }
            mapConfirmed.put(saleOrder.getExpectedRealisationDate(), amountCompanyCurr);
        }
    }

    @Transactional
    public void populateWithForecasts(ForecastRecap forecastRecap) {
        List forecastList = new ArrayList();
        forecastList = forecastRecap.getBankDetails() != null ? ((ForecastRepository)((Object)Beans.get(ForecastRepository.class))).all().filter("self.estimatedDate BETWEEN ?1 AND ?2 AND self.company = ?3 AND self.bankDetails = ?4 AND (self.realizedSelect = 2 OR (self.realizedSelect = 3 AND self.estimatedDate <= ?5))", new Object[]{forecastRecap.getFromDate(), forecastRecap.getToDate(), forecastRecap.getCompany(), forecastRecap.getBankDetails(), this.appBaseService.getTodayDate()}).fetch() : ((ForecastRepository)((Object)Beans.get(ForecastRepository.class))).all().filter("self.estimatedDate BETWEEN ?1 AND ?2 AND self.company = ?3 AND (self.realizedSelect = 2 OR (self.realizedSelect = 3 AND self.estimatedDate <= ?4))", new Object[]{forecastRecap.getFromDate(), forecastRecap.getToDate(), forecastRecap.getCompany(), this.appBaseService.getTodayDate()}).fetch();
        for (Forecast forecast : forecastList) {
            ForecastReason forecastReason = forecast.getForecastReason();
            forecastRecap.addForecastRecapLineListItem(this.createForecastRecapLine(forecast.getEstimatedDate(), forecast.getTypeSelect(), forecast.getAmount(), ForecastReason.class.getName(), forecastReason.getId(), forecastReason.getReason()));
            forecast.setRealizedSelect(1);
            this.forecastRepo.save((Model)((Object)forecast));
        }
    }

    public void populateWithForecastsNoSave(ForecastRecap forecastRecap) {
        List forecastList = new ArrayList();
        forecastList = forecastRecap.getBankDetails() != null ? ((ForecastRepository)((Object)Beans.get(ForecastRepository.class))).all().filter("self.estimatedDate BETWEEN ?1 AND ?2 AND self.company = ?3 AND self.bankDetails = ?4 AND (self.realizedSelect = 2 OR (self.realizedSelect = 3 AND self.estimatedDate <= ?5))", new Object[]{forecastRecap.getFromDate(), forecastRecap.getToDate(), forecastRecap.getCompany(), forecastRecap.getBankDetails(), this.appBaseService.getTodayDate()}).fetch() : ((ForecastRepository)((Object)Beans.get(ForecastRepository.class))).all().filter("self.estimatedDate BETWEEN ?1 AND ?2 AND self.company = ?3 AND (self.realizedSelect = 2 OR (self.realizedSelect = 3 AND self.estimatedDate <= ?4))", new Object[]{forecastRecap.getFromDate(), forecastRecap.getToDate(), forecastRecap.getCompany(), this.appBaseService.getTodayDate()}).fetch();
        for (Forecast forecast : forecastList) {
            ForecastReason forecastReason = forecast.getForecastReason();
            forecastRecap.addForecastRecapLineListItem(this.createForecastRecapLine(forecast.getEstimatedDate(), forecast.getTypeSelect(), forecast.getAmount(), ForecastReason.class.getName(), forecastReason.getId(), forecastReason.getReason()));
        }
    }

    public void getForecasts(ForecastRecap forecastRecap, Map<LocalDate, BigDecimal> mapExpected, Map<LocalDate, BigDecimal> mapConfirmed) {
        List forecastList = new ArrayList();
        forecastList = forecastRecap.getBankDetails() != null ? ((ForecastRepository)((Object)Beans.get(ForecastRepository.class))).all().filter("self.estimatedDate BETWEEN ?1 AND ?2 AND self.company = ?3 AND self.bankDetails = ?4 AND (self.realizedSelect = 2 OR self.realizedSelect = 3)", new Object[]{forecastRecap.getFromDate(), forecastRecap.getToDate(), forecastRecap.getCompany(), forecastRecap.getBankDetails()}).fetch() : ((ForecastRepository)((Object)Beans.get(ForecastRepository.class))).all().filter("self.estimatedDate BETWEEN ?1 AND ?2 AND self.company = ?3 AND (self.realizedSelect = 2 OR self.realizedSelect = 3)", new Object[]{forecastRecap.getFromDate(), forecastRecap.getToDate(), forecastRecap.getCompany()}).fetch();
        for (Forecast forecast : forecastList) {
            if (forecast.getTypeSelect() != 1) continue;
            if (forecast.getRealizedSelect() == 2) {
                if (mapExpected.containsKey(forecast.getEstimatedDate())) {
                    mapExpected.put(forecast.getEstimatedDate(), mapExpected.get(forecast.getEstimatedDate()).add(forecast.getAmount()));
                    continue;
                }
                mapExpected.put(forecast.getEstimatedDate(), forecast.getAmount());
                continue;
            }
            if (mapConfirmed.containsKey(forecast.getEstimatedDate())) {
                mapConfirmed.put(forecast.getEstimatedDate(), mapConfirmed.get(forecast.getEstimatedDate()).add(forecast.getAmount()));
                continue;
            }
            mapConfirmed.put(forecast.getEstimatedDate(), forecast.getAmount());
        }
    }

    public void populateWithExpenses(ForecastRecap forecastRecap) {
        List expenseList = new ArrayList();
        expenseList = forecastRecap.getBankDetails() != null ? ((ExpenseRepository)Beans.get(ExpenseRepository.class)).all().filter("self.validationDate BETWEEN ?1 AND ?2 AND self.company = ?3 AND self.bankDetails = ?4 AND self.statusSelect = 3", new Object[]{forecastRecap.getFromDate(), forecastRecap.getToDate(), forecastRecap.getCompany(), forecastRecap.getBankDetails()}).fetch() : ((ExpenseRepository)Beans.get(ExpenseRepository.class)).all().filter("self.validationDate BETWEEN ?1 AND ?2 AND self.company = ?3 AND self.statusSelect = 3", new Object[]{forecastRecap.getFromDate(), forecastRecap.getToDate(), forecastRecap.getCompany()}).fetch();
        for (Expense expense : expenseList) {
            forecastRecap.addForecastRecapLineListItem(this.createForecastRecapLine(expense.getValidationDate(), 2, expense.getExTaxTotal(), Expense.class.getName(), expense.getId(), expense.getExpenseSeq()));
        }
    }

    public ForecastRecapLine createForecastRecapLine(LocalDate date, int type, BigDecimal amount, String relatedToSelect, Long relatedToSelectId, String relatedToSelectName) {
        ForecastRecapLine forecastRecapLine = new ForecastRecapLine();
        forecastRecapLine.setEstimatedDate(date);
        forecastRecapLine.setTypeSelect(type);
        forecastRecapLine.setAmount(amount);
        forecastRecapLine.setRelatedToSelect(relatedToSelect);
        forecastRecapLine.setRelatedToSelectId(relatedToSelectId);
        forecastRecapLine.setRelatedToSelectName(relatedToSelectName);
        return forecastRecapLine;
    }

    public void computeForecastRecapLineBalance(ForecastRecap forecastRecap) {
        List<ForecastRecapLine> forecastRecapLines = forecastRecap.getForecastRecapLineList();
        Collections.sort(forecastRecapLines, new Comparator<ForecastRecapLine>(){

            @Override
            public int compare(ForecastRecapLine forecastRecapLine1, ForecastRecapLine forecastRecapLine2) {
                int compareEstimatedDate = forecastRecapLine1.getEstimatedDate().compareTo(forecastRecapLine2.getEstimatedDate());
                int compareTypeSelect = forecastRecapLine1.getTypeSelect().compareTo(forecastRecapLine2.getTypeSelect());
                int compareId = forecastRecapLine1.getId().compareTo(forecastRecapLine2.getId());
                if (compareEstimatedDate == 0) {
                    return compareTypeSelect == 0 ? compareId : compareTypeSelect;
                }
                return compareEstimatedDate;
            }
        });
        for (ForecastRecapLine forecastRecapLine : forecastRecapLines) {
            if (forecastRecapLine.getTypeSelect() == 1) {
                forecastRecap.setCurrentBalance(forecastRecap.getCurrentBalance().add(forecastRecapLine.getAmount()));
                forecastRecapLine.setBalance(forecastRecap.getCurrentBalance());
                continue;
            }
            forecastRecap.setCurrentBalance(forecastRecap.getCurrentBalance().subtract(forecastRecapLine.getAmount()));
            forecastRecapLine.setBalance(forecastRecap.getCurrentBalance());
        }
        forecastRecap.setForecastRecapLineList(forecastRecapLines);
    }

    public String getForecastRecapFileLink(Long forecastRecapId, String reportType) throws AxelorException {
        String title = I18n.get((String)"ForecastRecap");
        title = title + forecastRecapId;
        return ReportFactory.createReport((String)"ForecastRecap.rptdesign", (String)(title + "-${date}")).addParam("ForecastRecapId", (Object)forecastRecapId.toString()).addParam("Locale", (Object)ReportSettings.getPrintingLocale(null)).addFormat(reportType).generate().getFileLink();
    }
}

