/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.cash.management.service;

import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.cash.management.db.Forecast;
import com.axelor.apps.cash.management.db.ForecastGenerator;
import com.axelor.apps.cash.management.db.ForecastReason;
import com.axelor.apps.cash.management.db.repo.ForecastRepository;
import com.axelor.db.Model;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

public class ForecastService {
    @Inject
    protected AppBaseService appBaseService;
    @Inject
    protected ForecastRepository forecastRepo;

    @Transactional
    public void generate(ForecastGenerator forecastGenerator) {
        LocalDate fromDate = forecastGenerator.getFromDate();
        LocalDate toDate = forecastGenerator.getToDate();
        LocalDate itDate = LocalDate.parse(fromDate.toString(), DateTimeFormatter.ISO_DATE);
        int count = 0;
        this.reset(forecastGenerator);
        while (!itDate.isAfter(toDate)) {
            Forecast forecast = this.createForecast(forecastGenerator, forecastGenerator.getCompany(), forecastGenerator.getBankDetails(), forecastGenerator.getTypeSelect(), forecastGenerator.getAmount(), itDate, forecastGenerator.getForecastReason(), forecastGenerator.getComments(), forecastGenerator.getRealizedSelect());
            this.forecastRepo.save((Model)((Object)forecast));
            itDate = fromDate.plusMonths(++count * forecastGenerator.getPeriodicitySelect());
        }
    }

    public Forecast createForecast(ForecastGenerator forecastGenerator, Company company, BankDetails bankDetails, int typeSelect, BigDecimal amount, LocalDate estimatedDate, ForecastReason reason, String comments, int realizedSelect) {
        Forecast forecast = new Forecast();
        forecast.setForecastGenerator(forecastGenerator);
        forecast.setCompany(company);
        forecast.setBankDetails(bankDetails);
        forecast.setTypeSelect(typeSelect);
        forecast.setAmount(amount);
        forecast.setEstimatedDate(estimatedDate);
        forecast.setForecastReason(reason);
        forecast.setComments(comments);
        forecast.setRealizedSelect(realizedSelect);
        return forecast;
    }

    @Transactional
    public void reset(ForecastGenerator forecastGenerator) {
        this.forecastRepo.all().filter("self.forecastGenerator = ? AND (self.realizedSelect = ? OR (self.realizedSelect = ? AND self.estimatedDate > ?))", new Object[]{forecastGenerator, 2, 3, this.appBaseService.getTodayDate()}).remove();
    }
}

