/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.internal.javax.el;

import com.axelor.internal.javax.el.ELException;
import com.axelor.internal.javax.el.Util;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ImportHandler {
    private List<String> packageNames = new ArrayList<String>();
    private ConcurrentHashMap<String, String> classNames = new ConcurrentHashMap();
    private Map<String, Class<?>> clazzes = new ConcurrentHashMap();
    private Map<String, Class<?>> statics = new ConcurrentHashMap();

    public ImportHandler() {
        this.importPackage("java.lang");
    }

    public void importStatic(String name) throws ELException {
        int modifiers;
        int lastPeriod = name.lastIndexOf(46);
        if (lastPeriod < 0) {
            throw new ELException(Util.message(null, "importHandler.invalidStaticName", name));
        }
        String className = name.substring(0, lastPeriod);
        String fieldOrMethodName = name.substring(lastPeriod + 1);
        Class<?> clazz = this.findClass(className, true);
        if (clazz == null) {
            throw new ELException(Util.message(null, "importHandler.invalidClassNameForStatic", className, name));
        }
        boolean found = false;
        for (Field field : clazz.getFields()) {
            if (!field.getName().equals(fieldOrMethodName) || !Modifier.isStatic(modifiers = field.getModifiers()) || !Modifier.isPublic(modifiers)) continue;
            found = true;
            break;
        }
        if (!found) {
            for (AccessibleObject accessibleObject : clazz.getMethods()) {
                if (!((Method)accessibleObject).getName().equals(fieldOrMethodName) || !Modifier.isStatic(modifiers = ((Method)accessibleObject).getModifiers()) || !Modifier.isPublic(modifiers)) continue;
                found = true;
                break;
            }
        }
        if (!found) {
            throw new ELException(Util.message(null, "importHandler.staticNotFound", fieldOrMethodName, className, name));
        }
        Class<?> conflict = this.statics.get(fieldOrMethodName);
        if (conflict != null) {
            throw new ELException(Util.message(null, "importHandler.ambiguousStaticImport", name, conflict.getName() + '.' + fieldOrMethodName));
        }
        this.statics.put(fieldOrMethodName, clazz);
    }

    public void importClass(String name) throws ELException {
        int lastPeriodIndex = name.lastIndexOf(46);
        if (lastPeriodIndex < 0) {
            throw new ELException(Util.message(null, "importHandler.invalidClassName", name));
        }
        String unqualifiedName = name.substring(lastPeriodIndex + 1);
        String currentName = this.classNames.putIfAbsent(unqualifiedName, name);
        if (currentName != null && !currentName.equals(name)) {
            throw new ELException(Util.message(null, "importHandler.ambiguousImport", name, currentName));
        }
    }

    public void importPackage(String name) {
        this.packageNames.add(name);
    }

    public Class<?> resolveClass(String name) {
        Class<?> clazz;
        if (name == null || name.contains(".")) {
            return null;
        }
        Class<?> result = this.clazzes.get(name);
        if (result != null) {
            if (NotFound.class.equals(result)) {
                return null;
            }
            return result;
        }
        String className = this.classNames.get(name);
        if (className != null && (clazz = this.findClass(className, true)) != null) {
            this.clazzes.put(name, clazz);
            return clazz;
        }
        for (String p : this.packageNames) {
            className = p + '.' + name;
            Class<?> clazz2 = this.findClass(className, false);
            if (clazz2 == null) continue;
            if (result != null) {
                throw new ELException(Util.message(null, "importHandler.ambiguousImport", className, result.getName()));
            }
            result = clazz2;
        }
        if (result == null) {
            this.clazzes.put(name, NotFound.class);
        } else {
            this.clazzes.put(name, result);
        }
        return result;
    }

    public Class<?> resolveStatic(String name) {
        return this.statics.get(name);
    }

    private Class<?> findClass(String name, boolean throwException) {
        Class<?> clazz;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        String path = name.replace('.', '/') + ".class";
        try {
            if (cl.getResource(path) == null) {
                return null;
            }
        }
        catch (ClassCircularityError classCircularityError) {
            // empty catch block
        }
        try {
            clazz = cl.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        int modifiers = clazz.getModifiers();
        if (!Modifier.isPublic(modifiers) || Modifier.isAbstract(modifiers) || Modifier.isInterface(modifiers)) {
            if (throwException) {
                throw new ELException(Util.message(null, "importHandler.invalidClass", name));
            }
            return null;
        }
        return clazz;
    }

    private static class NotFound {
        private NotFound() {
        }
    }
}

