/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.ABCAnalysis;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BASE_ABC_ANALYSIS_CLASS", indexes={@Index(columnList="name"), @Index(columnList="abc_analysis")})
public class ABCAnalysisClass
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_ABC_ANALYSIS_CLASS_SEQ")
    @SequenceGenerator(name="BASE_ABC_ANALYSIS_CLASS_SEQ", sequenceName="BASE_ABC_ANALYSIS_CLASS_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Name")
    private String name;
    @Widget(title="Qty (%)")
    private BigDecimal qty = BigDecimal.ZERO;
    @Widget(title="Worth (%)")
    private BigDecimal worth = BigDecimal.ZERO;
    @Widget(title="Sequence")
    private Integer sequence = 0;
    @Widget(title="ABC Analysis")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ABCAnalysis abcAnalysis;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public ABCAnalysisClass() {
    }

    public ABCAnalysisClass(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BigDecimal getQty() {
        return this.qty == null ? BigDecimal.ZERO : this.qty;
    }

    public void setQty(BigDecimal qty) {
        this.qty = qty;
    }

    public BigDecimal getWorth() {
        return this.worth == null ? BigDecimal.ZERO : this.worth;
    }

    public void setWorth(BigDecimal worth) {
        this.worth = worth;
    }

    public Integer getSequence() {
        return this.sequence == null ? 0 : this.sequence;
    }

    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }

    public ABCAnalysis getAbcAnalysis() {
        return this.abcAnalysis;
    }

    public void setAbcAnalysis(ABCAnalysis abcAnalysis) {
        this.abcAnalysis = abcAnalysis;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ABCAnalysisClass)) {
            return false;
        }
        ABCAnalysisClass other = (ABCAnalysisClass)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("qty", (Object)this.getQty()).add("worth", (Object)this.getWorth()).add("sequence", (Object)this.getSequence()).omitNullValues().toString();
    }
}

