/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.ABCAnalysis;
import com.axelor.apps.base.db.ABCAnalysisClass;
import com.axelor.apps.base.db.Product;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Digits;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BASE_ABC_ANALYSIS_LINE", indexes={@Index(columnList="abc_analysis"), @Index(columnList="abc_analysis_class"), @Index(columnList="product")})
public class ABCAnalysisLine
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_ABC_ANALYSIS_LINE_SEQ")
    @SequenceGenerator(name="BASE_ABC_ANALYSIS_LINE_SEQ", sequenceName="BASE_ABC_ANALYSIS_LINE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="ABC Analysis")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ABCAnalysis abcAnalysis;
    @Widget(title="Class")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ABCAnalysisClass abcAnalysisClass;
    @Widget(title="Product")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Product product;
    @Widget(title="Qty")
    private BigDecimal decimalQty = BigDecimal.ZERO;
    @Widget(title="Qty (%)")
    @Digits(integer=3, fraction=3)
    private BigDecimal qty = BigDecimal.ZERO;
    @Widget(title="Cumulated qty (%)")
    @Digits(integer=3, fraction=3)
    private BigDecimal cumulatedQty = BigDecimal.ZERO;
    @Widget(title="Worth")
    private BigDecimal decimalWorth = BigDecimal.ZERO;
    @Widget(title="Worth (%)")
    @Digits(integer=3, fraction=3)
    private BigDecimal worth = BigDecimal.ZERO;
    @Widget(title="Cumulated worth (%)")
    @Digits(integer=3, fraction=3)
    private BigDecimal cumulatedWorth = BigDecimal.ZERO;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public ABCAnalysis getAbcAnalysis() {
        return this.abcAnalysis;
    }

    public void setAbcAnalysis(ABCAnalysis abcAnalysis) {
        this.abcAnalysis = abcAnalysis;
    }

    public ABCAnalysisClass getAbcAnalysisClass() {
        return this.abcAnalysisClass;
    }

    public void setAbcAnalysisClass(ABCAnalysisClass abcAnalysisClass) {
        this.abcAnalysisClass = abcAnalysisClass;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public BigDecimal getDecimalQty() {
        return this.decimalQty == null ? BigDecimal.ZERO : this.decimalQty;
    }

    public void setDecimalQty(BigDecimal decimalQty) {
        this.decimalQty = decimalQty;
    }

    public BigDecimal getQty() {
        return this.qty == null ? BigDecimal.ZERO : this.qty;
    }

    public void setQty(BigDecimal qty) {
        this.qty = qty;
    }

    public BigDecimal getCumulatedQty() {
        return this.cumulatedQty == null ? BigDecimal.ZERO : this.cumulatedQty;
    }

    public void setCumulatedQty(BigDecimal cumulatedQty) {
        this.cumulatedQty = cumulatedQty;
    }

    public BigDecimal getDecimalWorth() {
        return this.decimalWorth == null ? BigDecimal.ZERO : this.decimalWorth;
    }

    public void setDecimalWorth(BigDecimal decimalWorth) {
        this.decimalWorth = decimalWorth;
    }

    public BigDecimal getWorth() {
        return this.worth == null ? BigDecimal.ZERO : this.worth;
    }

    public void setWorth(BigDecimal worth) {
        this.worth = worth;
    }

    public BigDecimal getCumulatedWorth() {
        return this.cumulatedWorth == null ? BigDecimal.ZERO : this.cumulatedWorth;
    }

    public void setCumulatedWorth(BigDecimal cumulatedWorth) {
        this.cumulatedWorth = cumulatedWorth;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ABCAnalysisLine)) {
            return false;
        }
        ABCAnalysisLine other = (ABCAnalysisLine)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("decimalQty", (Object)this.getDecimalQty()).add("qty", (Object)this.getQty()).add("cumulatedQty", (Object)this.getCumulatedQty()).add("decimalWorth", (Object)this.getDecimalWorth()).add("worth", (Object)this.getWorth()).add("cumulatedWorth", (Object)this.getCumulatedWorth()).omitNullValues().toString();
    }
}

