/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.City;
import com.axelor.apps.base.db.Country;
import com.axelor.apps.base.db.PickListEntry;
import com.axelor.apps.base.db.Street;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BASE_ADDRESS", indexes={@Index(columnList="addressl7country"), @Index(columnList="city"), @Index(columnList="street"), @Index(columnList="fullName")})
public class Address
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_ADDRESS_SEQ")
    @SequenceGenerator(name="BASE_ADDRESS_SEQ", sequenceName="BASE_ADDRESS_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Recipient details")
    private String addressL2;
    @Widget(title="Address precisions")
    private String addressL3;
    @Widget(title="N\u00b0 and Street label")
    @NotNull
    private String addressL4;
    @Widget(title="Distribution precisions (POB, Village...)")
    private String addressL5;
    @Widget(title="Zip/City")
    private String addressL6;
    @Widget(title="Country")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Country addressL7Country;
    @Widget(title="City")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private City city;
    @Widget(title="Latitude")
    @Digits(integer=20, fraction=18)
    @Column(nullable=true)
    private BigDecimal latit;
    @Widget(title="Longitude")
    @Digits(integer=20, fraction=18)
    @Column(nullable=true)
    private BigDecimal longit;
    @Widget(title="Valid Latitude Longitude")
    private Boolean isValidLatLong = Boolean.TRUE;
    @Widget(title="Default zoom")
    private Integer zoom = 0;
    @Widget(title="National Code", readonly=true)
    private String inseeCode;
    @Widget(title="Address certified by QAS engine", readonly=true)
    private Boolean certifiedOk = Boolean.FALSE;
    @Widget(title="QAS Proposal lists")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="address", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<PickListEntry> pickList;
    @Widget(title="Zip code")
    private String zip;
    @Widget(title="Street number")
    private String streetNumber;
    @Widget(title="Street")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Street street;
    @Widget(title="Address", search={"addressL2", "addressL3", "addressL4", "addressL5", "addressL6"})
    @NameColumn
    private String fullName;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getAddressL2() {
        return this.addressL2;
    }

    public void setAddressL2(String addressL2) {
        this.addressL2 = addressL2;
    }

    public String getAddressL3() {
        return this.addressL3;
    }

    public void setAddressL3(String addressL3) {
        this.addressL3 = addressL3;
    }

    public String getAddressL4() {
        return this.addressL4;
    }

    public void setAddressL4(String addressL4) {
        this.addressL4 = addressL4;
    }

    public String getAddressL5() {
        return this.addressL5;
    }

    public void setAddressL5(String addressL5) {
        this.addressL5 = addressL5;
    }

    public String getAddressL6() {
        return this.addressL6;
    }

    public void setAddressL6(String addressL6) {
        this.addressL6 = addressL6;
    }

    public Country getAddressL7Country() {
        return this.addressL7Country;
    }

    public void setAddressL7Country(Country addressL7Country) {
        this.addressL7Country = addressL7Country;
    }

    public City getCity() {
        return this.city;
    }

    public void setCity(City city) {
        this.city = city;
    }

    public BigDecimal getLatit() {
        return this.latit;
    }

    public void setLatit(BigDecimal latit) {
        this.latit = latit;
    }

    public BigDecimal getLongit() {
        return this.longit;
    }

    public void setLongit(BigDecimal longit) {
        this.longit = longit;
    }

    public Boolean getIsValidLatLong() {
        return this.isValidLatLong == null ? Boolean.FALSE : this.isValidLatLong;
    }

    public void setIsValidLatLong(Boolean isValidLatLong) {
        this.isValidLatLong = isValidLatLong;
    }

    public Integer getZoom() {
        return this.zoom == null ? 0 : this.zoom;
    }

    public void setZoom(Integer zoom) {
        this.zoom = zoom;
    }

    public String getInseeCode() {
        return this.inseeCode;
    }

    public void setInseeCode(String inseeCode) {
        this.inseeCode = inseeCode;
    }

    public Boolean getCertifiedOk() {
        return this.certifiedOk == null ? Boolean.FALSE : this.certifiedOk;
    }

    public void setCertifiedOk(Boolean certifiedOk) {
        this.certifiedOk = certifiedOk;
    }

    public List<PickListEntry> getPickList() {
        return this.pickList;
    }

    public void setPickList(List<PickListEntry> pickList) {
        this.pickList = pickList;
    }

    public void addPickListItem(PickListEntry item) {
        if (this.getPickList() == null) {
            this.setPickList(new ArrayList<PickListEntry>());
        }
        this.getPickList().add(item);
        item.setAddress(this);
    }

    public void removePickListItem(PickListEntry item) {
        if (this.getPickList() == null) {
            return;
        }
        this.getPickList().remove((Object)item);
    }

    public void clearPickList() {
        if (this.getPickList() != null) {
            this.getPickList().clear();
        }
    }

    public String getZip() {
        return this.zip;
    }

    public void setZip(String zip) {
        this.zip = zip;
    }

    public String getStreetNumber() {
        return this.streetNumber;
    }

    public void setStreetNumber(String streetNumber) {
        this.streetNumber = streetNumber;
    }

    public Street getStreet() {
        return this.street;
    }

    public void setStreet(Street street) {
        this.street = street;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Address)) {
            return false;
        }
        Address other = (Address)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("addressL2", (Object)this.getAddressL2()).add("addressL3", (Object)this.getAddressL3()).add("addressL4", (Object)this.getAddressL4()).add("addressL5", (Object)this.getAddressL5()).add("addressL6", (Object)this.getAddressL6()).add("latit", (Object)this.getLatit()).add("longit", (Object)this.getLongit()).add("isValidLatLong", (Object)this.getIsValidLatLong()).add("zoom", (Object)this.getZoom()).add("inseeCode", (Object)this.getInseeCode()).add("certifiedOk", (Object)this.getCertifiedOk()).omitNullValues().toString();
    }
}

