/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.AdvancedExportLine;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaModel;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BASE_ADVANCED_EXPORT", indexes={@Index(columnList="name"), @Index(columnList="meta_model")})
public class AdvancedExport
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_ADVANCED_EXPORT_SEQ")
    @SequenceGenerator(name="BASE_ADVANCED_EXPORT_SEQ", sequenceName="BASE_ADVANCED_EXPORT_SEQ", allocationSize=1)
    private Long id;
    private String name;
    @Widget(title="Target model")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaModel metaModel;
    @Widget(title="Advanced export line")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="advancedExport", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<AdvancedExportLine> advancedExportLineList;
    @Widget(title="Maximum export limit", help="Maximum number of records to export by using this advance export.")
    private Integer maxExportLimit = 1000;
    @Widget(title="Query fetch size", help="Number of records to fetch from database on one query run. It will fetch upto 'Maximum export limit'.")
    private Integer queryFetchSize = 100;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public AdvancedExport() {
    }

    public AdvancedExport(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MetaModel getMetaModel() {
        return this.metaModel;
    }

    public void setMetaModel(MetaModel metaModel) {
        this.metaModel = metaModel;
    }

    public List<AdvancedExportLine> getAdvancedExportLineList() {
        return this.advancedExportLineList;
    }

    public void setAdvancedExportLineList(List<AdvancedExportLine> advancedExportLineList) {
        this.advancedExportLineList = advancedExportLineList;
    }

    public void addAdvancedExportLineListItem(AdvancedExportLine item) {
        if (this.getAdvancedExportLineList() == null) {
            this.setAdvancedExportLineList(new ArrayList<AdvancedExportLine>());
        }
        this.getAdvancedExportLineList().add(item);
        item.setAdvancedExport(this);
    }

    public void removeAdvancedExportLineListItem(AdvancedExportLine item) {
        if (this.getAdvancedExportLineList() == null) {
            return;
        }
        this.getAdvancedExportLineList().remove((Object)item);
    }

    public void clearAdvancedExportLineList() {
        if (this.getAdvancedExportLineList() != null) {
            this.getAdvancedExportLineList().clear();
        }
    }

    public Integer getMaxExportLimit() {
        return this.maxExportLimit == null ? 0 : this.maxExportLimit;
    }

    public void setMaxExportLimit(Integer maxExportLimit) {
        this.maxExportLimit = maxExportLimit;
    }

    public Integer getQueryFetchSize() {
        return this.queryFetchSize == null ? 0 : this.queryFetchSize;
    }

    public void setQueryFetchSize(Integer queryFetchSize) {
        this.queryFetchSize = queryFetchSize;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AdvancedExport)) {
            return false;
        }
        AdvancedExport other = (AdvancedExport)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("maxExportLimit", (Object)this.getMaxExportLimit()).add("queryFetchSize", (Object)this.getQueryFetchSize()).omitNullValues().toString();
    }
}

