/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.AlarmMessage;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaModel;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="BASE_ALARM_ENGINE", indexes={@Index(columnList="code"), @Index(columnList="meta_model"), @Index(columnList="alarm_message")})
public class AlarmEngine
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_ALARM_ENGINE_SEQ")
    @SequenceGenerator(name="BASE_ALARM_ENGINE_SEQ", sequenceName="BASE_ALARM_ENGINE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Code")
    @NotNull
    private String code;
    @Widget(title="Model")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaModel metaModel;
    @Widget(title="Message")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AlarmMessage alarmMessage;
    @Widget(title="Manager Type", selection="alarm.engine.manager.type")
    private Integer managerTypeSelect = 0;
    @Widget(title="Active")
    private Boolean activeOk = Boolean.TRUE;
    @Widget(title="Blocking")
    private Boolean lockingOk = Boolean.FALSE;
    @Widget(title="External")
    private Boolean externalOk = Boolean.FALSE;
    @Widget(title="Query")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String query;
    @Widget(title="Description")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String description;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public AlarmEngine() {
    }

    public AlarmEngine(String code) {
        this.code = code;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public MetaModel getMetaModel() {
        return this.metaModel;
    }

    public void setMetaModel(MetaModel metaModel) {
        this.metaModel = metaModel;
    }

    public AlarmMessage getAlarmMessage() {
        return this.alarmMessage;
    }

    public void setAlarmMessage(AlarmMessage alarmMessage) {
        this.alarmMessage = alarmMessage;
    }

    public Integer getManagerTypeSelect() {
        return this.managerTypeSelect == null ? 0 : this.managerTypeSelect;
    }

    public void setManagerTypeSelect(Integer managerTypeSelect) {
        this.managerTypeSelect = managerTypeSelect;
    }

    public Boolean getActiveOk() {
        return this.activeOk == null ? Boolean.FALSE : this.activeOk;
    }

    public void setActiveOk(Boolean activeOk) {
        this.activeOk = activeOk;
    }

    public Boolean getLockingOk() {
        return this.lockingOk == null ? Boolean.FALSE : this.lockingOk;
    }

    public void setLockingOk(Boolean lockingOk) {
        this.lockingOk = lockingOk;
    }

    public Boolean getExternalOk() {
        return this.externalOk == null ? Boolean.FALSE : this.externalOk;
    }

    public void setExternalOk(Boolean externalOk) {
        this.externalOk = externalOk;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AlarmEngine)) {
            return false;
        }
        AlarmEngine other = (AlarmEngine)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("code", (Object)this.getCode()).add("managerTypeSelect", (Object)this.getManagerTypeSelect()).add("activeOk", (Object)this.getActiveOk()).add("lockingOk", (Object)this.getLockingOk()).add("externalOk", (Object)this.getExternalOk()).omitNullValues().toString();
    }
}

