/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.AlarmEngine;
import com.axelor.apps.base.db.Batch;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaModel;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BASE_ALARM_ENGINE_BATCH")
public class AlarmEngineBatch
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_ALARM_ENGINE_BATCH_SEQ")
    @SequenceGenerator(name="BASE_ALARM_ENGINE_BATCH_SEQ", sequenceName="BASE_ALARM_ENGINE_BATCH_SEQ", allocationSize=1)
    private Long id;
    @HashKey
    @Widget(title="Code")
    @NotNull
    @Column(unique=true)
    private String code;
    @Widget(title="Model")
    @NotNull
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<MetaModel> metaModelSet;
    @Widget(title="Alarm Engine")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<AlarmEngine> alarmEngineSet;
    @Widget(title="Description")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String description;
    @Widget(title="Batchs")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="alarmEngineBatch", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<Batch> batchList;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public AlarmEngineBatch() {
    }

    public AlarmEngineBatch(String code) {
        this.code = code;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Set<MetaModel> getMetaModelSet() {
        return this.metaModelSet;
    }

    public void setMetaModelSet(Set<MetaModel> metaModelSet) {
        this.metaModelSet = metaModelSet;
    }

    public void addMetaModelSetItem(MetaModel item) {
        if (this.getMetaModelSet() == null) {
            this.setMetaModelSet(new HashSet<MetaModel>());
        }
        this.getMetaModelSet().add(item);
    }

    public void removeMetaModelSetItem(MetaModel item) {
        if (this.getMetaModelSet() == null) {
            return;
        }
        this.getMetaModelSet().remove(item);
    }

    public void clearMetaModelSet() {
        if (this.getMetaModelSet() != null) {
            this.getMetaModelSet().clear();
        }
    }

    public Set<AlarmEngine> getAlarmEngineSet() {
        return this.alarmEngineSet;
    }

    public void setAlarmEngineSet(Set<AlarmEngine> alarmEngineSet) {
        this.alarmEngineSet = alarmEngineSet;
    }

    public void addAlarmEngineSetItem(AlarmEngine item) {
        if (this.getAlarmEngineSet() == null) {
            this.setAlarmEngineSet(new HashSet<AlarmEngine>());
        }
        this.getAlarmEngineSet().add(item);
    }

    public void removeAlarmEngineSetItem(AlarmEngine item) {
        if (this.getAlarmEngineSet() == null) {
            return;
        }
        this.getAlarmEngineSet().remove((Object)item);
    }

    public void clearAlarmEngineSet() {
        if (this.getAlarmEngineSet() != null) {
            this.getAlarmEngineSet().clear();
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<Batch> getBatchList() {
        return this.batchList;
    }

    public void setBatchList(List<Batch> batchList) {
        this.batchList = batchList;
    }

    public void addBatchListItem(Batch item) {
        if (this.getBatchList() == null) {
            this.setBatchList(new ArrayList<Batch>());
        }
        this.getBatchList().add(item);
        item.setAlarmEngineBatch(this);
    }

    public void removeBatchListItem(Batch item) {
        if (this.getBatchList() == null) {
            return;
        }
        this.getBatchList().remove((Object)item);
    }

    public void clearBatchList() {
        if (this.getBatchList() != null) {
            this.getBatchList().clear();
        }
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AlarmEngineBatch)) {
            return false;
        }
        AlarmEngineBatch other = (AlarmEngineBatch)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals(this.getCode(), other.getCode());
    }

    public int hashCode() {
        return Objects.hash(130911015, this.getCode());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("code", (Object)this.getCode()).omitNullValues().toString();
    }
}

