/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.App;
import com.axelor.apps.base.db.BarcodeTypeConfig;
import com.axelor.apps.base.db.CurrencyConversionLine;
import com.axelor.apps.base.db.Language;
import com.axelor.apps.base.db.Unit;
import com.axelor.apps.message.db.Template;
import com.axelor.db.EntityHelper;
import com.axelor.db.Model;
import com.axelor.db.annotations.Track;
import com.axelor.db.annotations.TrackEvent;
import com.axelor.db.annotations.TrackField;
import com.axelor.db.annotations.Widget;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BASE_APP_BASE", indexes={@Index(columnList="default_project_unit"), @Index(columnList="default_partner_language"), @Index(columnList="unit_days"), @Index(columnList="unit_hours"), @Index(columnList="unit_minutes"), @Index(columnList="barcode_type_config"), @Index(columnList="password_changed_template")})
@Track(fields={@TrackField(name="today", on={TrackEvent.UPDATE}), @TrackField(name="defaultProjectUnit", on={TrackEvent.UPDATE}), @TrackField(name="defaultPartnerLanguage", on={TrackEvent.UPDATE}), @TrackField(name="emailAccountByUser", on={TrackEvent.UPDATE}), @TrackField(name="qasWsdlUrl", on={TrackEvent.UPDATE}), @TrackField(name="mapApiSelect", on={TrackEvent.UPDATE}), @TrackField(name="googleMapsApiKey", on={TrackEvent.UPDATE}), @TrackField(name="currencyWsURL", on={TrackEvent.UPDATE}), @TrackField(name="hasQasValidation", on={TrackEvent.UPDATE}), @TrackField(name="productInAtiSelect", on={TrackEvent.UPDATE}), @TrackField(name="nbDecimalDigitForUnitPrice", on={TrackEvent.UPDATE}), @TrackField(name="computeMethodDiscountSelect", on={TrackEvent.UPDATE}), @TrackField(name="timeLoggingPreferenceSelect", on={TrackEvent.UPDATE}), @TrackField(name="dailyWorkHours", on={TrackEvent.UPDATE}), @TrackField(name="unitDays", on={TrackEvent.UPDATE}), @TrackField(name="unitHours", on={TrackEvent.UPDATE}), @TrackField(name="unitMinutes", on={TrackEvent.UPDATE}), @TrackField(name="teamManagement", on={TrackEvent.UPDATE}), @TrackField(name="activateSendingEmail", on={TrackEvent.UPDATE}), @TrackField(name="activateBarCodeGeneration", on={TrackEvent.UPDATE}), @TrackField(name="editProductBarcodeType", on={TrackEvent.UPDATE}), @TrackField(name="barcodeTypeConfig", on={TrackEvent.UPDATE}), @TrackField(name="generateProductSequence", on={TrackEvent.UPDATE}), @TrackField(name="manageMultiBanks", on={TrackEvent.UPDATE}), @TrackField(name="manageProductVariants", on={TrackEvent.UPDATE}), @TrackField(name="enterpriseCommunication", on={TrackEvent.UPDATE}), @TrackField(name="document", on={TrackEvent.UPDATE}), @TrackField(name="enableTradingNamesManagement", on={TrackEvent.UPDATE}), @TrackField(name="enableCalendars", on={TrackEvent.UPDATE}), @TrackField(name="passwordChangedTemplate", on={TrackEvent.UPDATE}), @TrackField(name="generatePartnerSequence", on={TrackEvent.UPDATE})})
public class AppBase
extends App {
    @Widget(title="Today date")
    private ZonedDateTime today;
    @Widget(title="Default Project unit")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Unit defaultProjectUnit;
    @Widget(title="Default Partner language")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Language defaultPartnerLanguage;
    @Widget(title="Manage mail account by user")
    private Boolean emailAccountByUser = Boolean.FALSE;
    @Widget(title="Store streets")
    private Boolean storeStreets = Boolean.FALSE;
    @Widget(title="URL to QAS WSDL")
    private String qasWsdlUrl;
    @Widget(title="Mapping service provider", selection="base.app.base.map.api.select")
    private Integer mapApiSelect = 1;
    @Widget(title="Routing service provider for Open Street Map", selection="base.app.base.osm.routing.api.select")
    private Integer osmRoutingServiceApiSelect = 1;
    @Widget(title="Google Maps API key")
    private String googleMapsApiKey;
    @Widget(title="Currency Ws URL", selection="base.app.base.currency.api.select")
    private String currencyWsURL;
    @Widget(title="Currency conversion table")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="appBase", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<CurrencyConversionLine> currencyConversionLineList;
    @Widget(title="Use QAS Validation")
    private Boolean hasQasValidation = Boolean.FALSE;
    @Widget(title="Products ATI/WT", selection="base.in.ati.select")
    private Integer productInAtiSelect = 1;
    @Widget(title="Nb of digits for unit prices")
    @Max(value=10L)
    private Integer nbDecimalDigitForUnitPrice = 2;
    @Widget(title="Compute Method for Discounts", selection="base.compute.method.discount.select")
    private Integer computeMethodDiscountSelect = 1;
    @Widget(title="Time logging preference", selection="hr.time.logging.preference.select")
    private String timeLoggingPreferenceSelect = "days";
    @Widget(title="Daily Work Hours")
    private BigDecimal dailyWorkHours = BigDecimal.ZERO;
    @Widget(title="Days Unit")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Unit unitDays;
    @Widget(title="Hours Unit")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Unit unitHours;
    @Widget(title="Minutes Unit")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Unit unitMinutes;
    @Widget(title="Team Management")
    private Boolean teamManagement = Boolean.TRUE;
    @Widget(title="Activate sending email")
    private Boolean activateSendingEmail = Boolean.TRUE;
    @Widget(title="Activate bar code generation for products")
    private Boolean activateBarCodeGeneration = Boolean.FALSE;
    @Widget(title="Edit product barcode type")
    private Boolean editProductBarcodeType = Boolean.FALSE;
    @Widget(title="Barcode Type")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private BarcodeTypeConfig barcodeTypeConfig;
    @Widget(title="Generate sequence for products")
    private Boolean generateProductSequence = Boolean.FALSE;
    @Widget(title="Generate sequence for partners")
    private Boolean generatePartnerSequence = Boolean.TRUE;
    @Widget(title="Manage multi banks")
    private Boolean manageMultiBanks = Boolean.FALSE;
    @Widget(title="Manage product variants")
    private Boolean manageProductVariants = Boolean.FALSE;
    @Widget(title="Messaging")
    private Boolean enterpriseCommunication = Boolean.TRUE;
    @Widget(title="Documents")
    private Boolean document = Boolean.TRUE;
    private Boolean enableTradingNamesManagement = Boolean.FALSE;
    @Widget(title="Calendar")
    private Boolean enableCalendars = Boolean.TRUE;
    @Widget(title="Enable multi-company management")
    private Boolean enableMultiCompany = Boolean.TRUE;
    @Widget(title="Template for changed password")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Template passwordChangedTemplate;
    @Widget(title="Number of tasks generated at most at once")
    @Min(value=1L)
    private Integer limitNumberTasksGenerated = 100;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public ZonedDateTime getToday() {
        return this.today;
    }

    public void setToday(ZonedDateTime today) {
        this.today = today;
    }

    public Unit getDefaultProjectUnit() {
        return this.defaultProjectUnit;
    }

    public void setDefaultProjectUnit(Unit defaultProjectUnit) {
        this.defaultProjectUnit = defaultProjectUnit;
    }

    public Language getDefaultPartnerLanguage() {
        return this.defaultPartnerLanguage;
    }

    public void setDefaultPartnerLanguage(Language defaultPartnerLanguage) {
        this.defaultPartnerLanguage = defaultPartnerLanguage;
    }

    public Boolean getEmailAccountByUser() {
        return this.emailAccountByUser == null ? Boolean.FALSE : this.emailAccountByUser;
    }

    public void setEmailAccountByUser(Boolean emailAccountByUser) {
        this.emailAccountByUser = emailAccountByUser;
    }

    public Boolean getStoreStreets() {
        return this.storeStreets == null ? Boolean.FALSE : this.storeStreets;
    }

    public void setStoreStreets(Boolean storeStreets) {
        this.storeStreets = storeStreets;
    }

    public String getQasWsdlUrl() {
        return this.qasWsdlUrl;
    }

    public void setQasWsdlUrl(String qasWsdlUrl) {
        this.qasWsdlUrl = qasWsdlUrl;
    }

    public Integer getMapApiSelect() {
        return this.mapApiSelect == null ? 0 : this.mapApiSelect;
    }

    public void setMapApiSelect(Integer mapApiSelect) {
        this.mapApiSelect = mapApiSelect;
    }

    public Integer getOsmRoutingServiceApiSelect() {
        return this.osmRoutingServiceApiSelect == null ? 0 : this.osmRoutingServiceApiSelect;
    }

    public void setOsmRoutingServiceApiSelect(Integer osmRoutingServiceApiSelect) {
        this.osmRoutingServiceApiSelect = osmRoutingServiceApiSelect;
    }

    public String getGoogleMapsApiKey() {
        return this.googleMapsApiKey;
    }

    public void setGoogleMapsApiKey(String googleMapsApiKey) {
        this.googleMapsApiKey = googleMapsApiKey;
    }

    public String getCurrencyWsURL() {
        return this.currencyWsURL;
    }

    public void setCurrencyWsURL(String currencyWsURL) {
        this.currencyWsURL = currencyWsURL;
    }

    public List<CurrencyConversionLine> getCurrencyConversionLineList() {
        return this.currencyConversionLineList;
    }

    public void setCurrencyConversionLineList(List<CurrencyConversionLine> currencyConversionLineList) {
        this.currencyConversionLineList = currencyConversionLineList;
    }

    public void addCurrencyConversionLineListItem(CurrencyConversionLine item) {
        if (this.getCurrencyConversionLineList() == null) {
            this.setCurrencyConversionLineList(new ArrayList<CurrencyConversionLine>());
        }
        this.getCurrencyConversionLineList().add(item);
        item.setAppBase(this);
    }

    public void removeCurrencyConversionLineListItem(CurrencyConversionLine item) {
        if (this.getCurrencyConversionLineList() == null) {
            return;
        }
        this.getCurrencyConversionLineList().remove((Object)item);
    }

    public void clearCurrencyConversionLineList() {
        if (this.getCurrencyConversionLineList() != null) {
            this.getCurrencyConversionLineList().clear();
        }
    }

    public Boolean getHasQasValidation() {
        return this.hasQasValidation == null ? Boolean.FALSE : this.hasQasValidation;
    }

    public void setHasQasValidation(Boolean hasQasValidation) {
        this.hasQasValidation = hasQasValidation;
    }

    public Integer getProductInAtiSelect() {
        return this.productInAtiSelect == null ? 0 : this.productInAtiSelect;
    }

    public void setProductInAtiSelect(Integer productInAtiSelect) {
        this.productInAtiSelect = productInAtiSelect;
    }

    public Integer getNbDecimalDigitForUnitPrice() {
        return this.nbDecimalDigitForUnitPrice == null ? 0 : this.nbDecimalDigitForUnitPrice;
    }

    public void setNbDecimalDigitForUnitPrice(Integer nbDecimalDigitForUnitPrice) {
        this.nbDecimalDigitForUnitPrice = nbDecimalDigitForUnitPrice;
    }

    public Integer getComputeMethodDiscountSelect() {
        return this.computeMethodDiscountSelect == null ? 0 : this.computeMethodDiscountSelect;
    }

    public void setComputeMethodDiscountSelect(Integer computeMethodDiscountSelect) {
        this.computeMethodDiscountSelect = computeMethodDiscountSelect;
    }

    public String getTimeLoggingPreferenceSelect() {
        return this.timeLoggingPreferenceSelect;
    }

    public void setTimeLoggingPreferenceSelect(String timeLoggingPreferenceSelect) {
        this.timeLoggingPreferenceSelect = timeLoggingPreferenceSelect;
    }

    public BigDecimal getDailyWorkHours() {
        return this.dailyWorkHours == null ? BigDecimal.ZERO : this.dailyWorkHours;
    }

    public void setDailyWorkHours(BigDecimal dailyWorkHours) {
        this.dailyWorkHours = dailyWorkHours;
    }

    public Unit getUnitDays() {
        return this.unitDays;
    }

    public void setUnitDays(Unit unitDays) {
        this.unitDays = unitDays;
    }

    public Unit getUnitHours() {
        return this.unitHours;
    }

    public void setUnitHours(Unit unitHours) {
        this.unitHours = unitHours;
    }

    public Unit getUnitMinutes() {
        return this.unitMinutes;
    }

    public void setUnitMinutes(Unit unitMinutes) {
        this.unitMinutes = unitMinutes;
    }

    public Boolean getTeamManagement() {
        return this.teamManagement == null ? Boolean.FALSE : this.teamManagement;
    }

    public void setTeamManagement(Boolean teamManagement) {
        this.teamManagement = teamManagement;
    }

    public Boolean getActivateSendingEmail() {
        return this.activateSendingEmail == null ? Boolean.FALSE : this.activateSendingEmail;
    }

    public void setActivateSendingEmail(Boolean activateSendingEmail) {
        this.activateSendingEmail = activateSendingEmail;
    }

    public Boolean getActivateBarCodeGeneration() {
        return this.activateBarCodeGeneration == null ? Boolean.FALSE : this.activateBarCodeGeneration;
    }

    public void setActivateBarCodeGeneration(Boolean activateBarCodeGeneration) {
        this.activateBarCodeGeneration = activateBarCodeGeneration;
    }

    public Boolean getEditProductBarcodeType() {
        return this.editProductBarcodeType == null ? Boolean.FALSE : this.editProductBarcodeType;
    }

    public void setEditProductBarcodeType(Boolean editProductBarcodeType) {
        this.editProductBarcodeType = editProductBarcodeType;
    }

    public BarcodeTypeConfig getBarcodeTypeConfig() {
        return this.barcodeTypeConfig;
    }

    public void setBarcodeTypeConfig(BarcodeTypeConfig barcodeTypeConfig) {
        this.barcodeTypeConfig = barcodeTypeConfig;
    }

    public Boolean getGenerateProductSequence() {
        return this.generateProductSequence == null ? Boolean.FALSE : this.generateProductSequence;
    }

    public void setGenerateProductSequence(Boolean generateProductSequence) {
        this.generateProductSequence = generateProductSequence;
    }

    public Boolean getGeneratePartnerSequence() {
        return this.generatePartnerSequence == null ? Boolean.FALSE : this.generatePartnerSequence;
    }

    public void setGeneratePartnerSequence(Boolean generatePartnerSequence) {
        this.generatePartnerSequence = generatePartnerSequence;
    }

    public Boolean getManageMultiBanks() {
        return this.manageMultiBanks == null ? Boolean.FALSE : this.manageMultiBanks;
    }

    public void setManageMultiBanks(Boolean manageMultiBanks) {
        this.manageMultiBanks = manageMultiBanks;
    }

    public Boolean getManageProductVariants() {
        return this.manageProductVariants == null ? Boolean.FALSE : this.manageProductVariants;
    }

    public void setManageProductVariants(Boolean manageProductVariants) {
        this.manageProductVariants = manageProductVariants;
    }

    public Boolean getEnterpriseCommunication() {
        return this.enterpriseCommunication == null ? Boolean.FALSE : this.enterpriseCommunication;
    }

    public void setEnterpriseCommunication(Boolean enterpriseCommunication) {
        this.enterpriseCommunication = enterpriseCommunication;
    }

    public Boolean getDocument() {
        return this.document == null ? Boolean.FALSE : this.document;
    }

    public void setDocument(Boolean document) {
        this.document = document;
    }

    public Boolean getEnableTradingNamesManagement() {
        return this.enableTradingNamesManagement == null ? Boolean.FALSE : this.enableTradingNamesManagement;
    }

    public void setEnableTradingNamesManagement(Boolean enableTradingNamesManagement) {
        this.enableTradingNamesManagement = enableTradingNamesManagement;
    }

    public Boolean getEnableCalendars() {
        return this.enableCalendars == null ? Boolean.FALSE : this.enableCalendars;
    }

    public void setEnableCalendars(Boolean enableCalendars) {
        this.enableCalendars = enableCalendars;
    }

    public Boolean getEnableMultiCompany() {
        return this.enableMultiCompany == null ? Boolean.FALSE : this.enableMultiCompany;
    }

    public void setEnableMultiCompany(Boolean enableMultiCompany) {
        this.enableMultiCompany = enableMultiCompany;
    }

    public Template getPasswordChangedTemplate() {
        return this.passwordChangedTemplate;
    }

    public void setPasswordChangedTemplate(Template passwordChangedTemplate) {
        this.passwordChangedTemplate = passwordChangedTemplate;
    }

    public Integer getLimitNumberTasksGenerated() {
        return this.limitNumberTasksGenerated == null ? 0 : this.limitNumberTasksGenerated;
    }

    public void setLimitNumberTasksGenerated(Integer limitNumberTasksGenerated) {
        this.limitNumberTasksGenerated = limitNumberTasksGenerated;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        return EntityHelper.equals((Model)((Object)this), (Object)obj);
    }

    public int hashCode() {
        return EntityHelper.hashCode((Model)((Object)this));
    }

    public String toString() {
        return EntityHelper.toString((Model)((Object)this));
    }
}

