/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.BankAddress;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Country;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BASE_BANK", indexes={@Index(columnList="country")})
public class Bank
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_BANK_SEQ")
    @SequenceGenerator(name="BASE_BANK_SEQ", sequenceName="BASE_BANK_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Name", search={"code", "bankName"})
    private String fullName;
    @Widget(title="Type of Bank Details Id", selection="base.bank.bank.details.type.select")
    @NotNull
    private Integer bankDetailsTypeSelect = 1;
    @HashKey
    @Widget(title="BIC (Bank Identifier)")
    @NameColumn
    @NotNull
    @Column(unique=true)
    private String code;
    @Widget(title="Bank Name")
    @Size(max=255)
    private String bankName;
    @Widget(title="Business Party Prefix (Bank Code)")
    @Size(min=4, max=4)
    private String businessPartyPrefix;
    @Widget(title="Country")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Country country;
    @Widget(title="Business Party Suffix (Location Code)")
    @Size(min=2, max=2)
    private String businessPartySuffix;
    @Widget(title="Branch Identifier (Branch Code)")
    @Size(max=3)
    private String branchIdentifier;
    @Widget(title="SWIFT address")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="bank", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<BankAddress> bankAddressList;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="bank", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<BankDetails> bankDetails;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Bank() {
    }

    public Bank(String code) {
        this.code = code;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public Integer getBankDetailsTypeSelect() {
        return this.bankDetailsTypeSelect == null ? 0 : this.bankDetailsTypeSelect;
    }

    public void setBankDetailsTypeSelect(Integer bankDetailsTypeSelect) {
        this.bankDetailsTypeSelect = bankDetailsTypeSelect;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getBankName() {
        return this.bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public String getBusinessPartyPrefix() {
        return this.businessPartyPrefix;
    }

    public void setBusinessPartyPrefix(String businessPartyPrefix) {
        this.businessPartyPrefix = businessPartyPrefix;
    }

    public Country getCountry() {
        return this.country;
    }

    public void setCountry(Country country) {
        this.country = country;
    }

    public String getBusinessPartySuffix() {
        return this.businessPartySuffix;
    }

    public void setBusinessPartySuffix(String businessPartySuffix) {
        this.businessPartySuffix = businessPartySuffix;
    }

    public String getBranchIdentifier() {
        return this.branchIdentifier;
    }

    public void setBranchIdentifier(String branchIdentifier) {
        this.branchIdentifier = branchIdentifier;
    }

    public List<BankAddress> getBankAddressList() {
        return this.bankAddressList;
    }

    public void setBankAddressList(List<BankAddress> bankAddressList) {
        this.bankAddressList = bankAddressList;
    }

    public void addBankAddressListItem(BankAddress item) {
        if (this.getBankAddressList() == null) {
            this.setBankAddressList(new ArrayList<BankAddress>());
        }
        this.getBankAddressList().add(item);
        item.setBank(this);
    }

    public void removeBankAddressListItem(BankAddress item) {
        if (this.getBankAddressList() == null) {
            return;
        }
        this.getBankAddressList().remove((Object)item);
    }

    public void clearBankAddressList() {
        if (this.getBankAddressList() != null) {
            this.getBankAddressList().clear();
        }
    }

    public List<BankDetails> getBankDetails() {
        return this.bankDetails;
    }

    public void setBankDetails(List<BankDetails> bankDetails) {
        this.bankDetails = bankDetails;
    }

    public void addBankDetail(BankDetails item) {
        if (this.getBankDetails() == null) {
            this.setBankDetails(new ArrayList<BankDetails>());
        }
        this.getBankDetails().add(item);
        item.setBank(this);
    }

    public void removeBankDetail(BankDetails item) {
        if (this.getBankDetails() == null) {
            return;
        }
        this.getBankDetails().remove((Object)item);
    }

    public void clearBankDetails() {
        if (this.getBankDetails() != null) {
            this.getBankDetails().clear();
        }
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Bank)) {
            return false;
        }
        Bank other = (Bank)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals(this.getCode(), other.getCode());
    }

    public int hashCode() {
        return Objects.hash(2062940, this.getCode());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("fullName", (Object)this.getFullName()).add("bankDetailsTypeSelect", (Object)this.getBankDetailsTypeSelect()).add("code", (Object)this.getCode()).add("bankName", (Object)this.getBankName()).add("businessPartyPrefix", (Object)this.getBusinessPartyPrefix()).add("businessPartySuffix", (Object)this.getBusinessPartySuffix()).add("branchIdentifier", (Object)this.getBranchIdentifier()).omitNullValues().toString();
    }
}

