/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.BirtTemplateParameter;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BASE_BIRT_TEMPLATE", indexes={@Index(columnList="name")})
public class BirtTemplate
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_BIRT_TEMPLATE_SEQ")
    @SequenceGenerator(name="BASE_BIRT_TEMPLATE_SEQ", sequenceName="BASE_BIRT_TEMPLATE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Name")
    @NotNull
    private String name;
    @Widget(title="Template file name")
    private String templateLink;
    @Widget(title="Format")
    private String format;
    @Widget(title="Parameters")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="birtTemplate", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<BirtTemplateParameter> birtTemplateParameterList;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public BirtTemplate() {
    }

    public BirtTemplate(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTemplateLink() {
        return this.templateLink;
    }

    public void setTemplateLink(String templateLink) {
        this.templateLink = templateLink;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public List<BirtTemplateParameter> getBirtTemplateParameterList() {
        return this.birtTemplateParameterList;
    }

    public void setBirtTemplateParameterList(List<BirtTemplateParameter> birtTemplateParameterList) {
        this.birtTemplateParameterList = birtTemplateParameterList;
    }

    public void addBirtTemplateParameterListItem(BirtTemplateParameter item) {
        if (this.getBirtTemplateParameterList() == null) {
            this.setBirtTemplateParameterList(new ArrayList<BirtTemplateParameter>());
        }
        this.getBirtTemplateParameterList().add(item);
        item.setBirtTemplate(this);
    }

    public void removeBirtTemplateParameterListItem(BirtTemplateParameter item) {
        if (this.getBirtTemplateParameterList() == null) {
            return;
        }
        this.getBirtTemplateParameterList().remove((Object)item);
    }

    public void clearBirtTemplateParameterList() {
        if (this.getBirtTemplateParameterList() != null) {
            this.getBirtTemplateParameterList().clear();
        }
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BirtTemplate)) {
            return false;
        }
        BirtTemplate other = (BirtTemplate)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("templateLink", (Object)this.getTemplateLink()).add("format", (Object)this.getFormat()).omitNullValues().toString();
    }
}

