/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.ICalendar;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.Group;
import com.axelor.auth.db.Role;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaAction;
import com.axelor.meta.db.MetaMenu;
import com.google.common.base.MoreObjects;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BASE_CALENDAR_CONFIGURATION", indexes={@Index(columnList="name"), @Index(columnList="meta_action"), @Index(columnList="calendar_user"), @Index(columnList="calendar_group"), @Index(columnList="role"), @Index(columnList="parent_meta_menu")})
public class CalendarConfiguration
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_CALENDAR_CONFIGURATION_SEQ")
    @SequenceGenerator(name="BASE_CALENDAR_CONFIGURATION_SEQ", sequenceName="BASE_CALENDAR_CONFIGURATION_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Name")
    @NotNull
    private String name;
    @Widget(title="Action")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaAction metaAction;
    @Widget(title="User")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User calendarUser;
    @Widget(title="Group")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Group calendarGroup;
    @Widget(title="Calendars")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<ICalendar> calendarSet;
    @Widget(title="Role")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Role role;
    @Widget(title="Parent Menu")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaMenu parentMetaMenu;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public CalendarConfiguration() {
    }

    public CalendarConfiguration(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MetaAction getMetaAction() {
        return this.metaAction;
    }

    public void setMetaAction(MetaAction metaAction) {
        this.metaAction = metaAction;
    }

    public User getCalendarUser() {
        return this.calendarUser;
    }

    public void setCalendarUser(User calendarUser) {
        this.calendarUser = calendarUser;
    }

    public Group getCalendarGroup() {
        return this.calendarGroup;
    }

    public void setCalendarGroup(Group calendarGroup) {
        this.calendarGroup = calendarGroup;
    }

    public Set<ICalendar> getCalendarSet() {
        return this.calendarSet;
    }

    public void setCalendarSet(Set<ICalendar> calendarSet) {
        this.calendarSet = calendarSet;
    }

    public void addCalendarSetItem(ICalendar item) {
        if (this.getCalendarSet() == null) {
            this.setCalendarSet(new HashSet<ICalendar>());
        }
        this.getCalendarSet().add(item);
    }

    public void removeCalendarSetItem(ICalendar item) {
        if (this.getCalendarSet() == null) {
            return;
        }
        this.getCalendarSet().remove((Object)item);
    }

    public void clearCalendarSet() {
        if (this.getCalendarSet() != null) {
            this.getCalendarSet().clear();
        }
    }

    public Role getRole() {
        return this.role;
    }

    public void setRole(Role role) {
        this.role = role;
    }

    public MetaMenu getParentMetaMenu() {
        return this.parentMetaMenu;
    }

    public void setParentMetaMenu(MetaMenu parentMetaMenu) {
        this.parentMetaMenu = parentMetaMenu;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CalendarConfiguration)) {
            return false;
        }
        CalendarConfiguration other = (CalendarConfiguration)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).omitNullValues().toString();
    }
}

