/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.Citizenship;
import com.axelor.apps.base.db.EconomicArea;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="BASE_COUNTRY", indexes={@Index(columnList="name"), @Index(columnList="economic_area"), @Index(columnList="citizenship")})
public class Country
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_COUNTRY_SEQ")
    @SequenceGenerator(name="BASE_COUNTRY_SEQ", sequenceName="BASE_COUNTRY_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Alpha-3 code (ISO)")
    @Size(min=3, max=3)
    private String alpha3Code;
    @Widget(title="Alpha-2 code (ISO)")
    @Size(min=2, max=2)
    private String alpha2Code;
    @Widget(title="Numeric code (ISO)")
    @Size(min=3, max=3)
    private String numericCode;
    @Widget(title="Country name")
    @NotNull
    private String name;
    @Widget(title="COG")
    private String cog;
    @Widget(title="Calling code")
    private String phonePrefix;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private EconomicArea economicArea;
    @Widget(title="Citizenship")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Citizenship citizenship;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Country() {
    }

    public Country(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getAlpha3Code() {
        return this.alpha3Code;
    }

    public void setAlpha3Code(String alpha3Code) {
        this.alpha3Code = alpha3Code;
    }

    public String getAlpha2Code() {
        return this.alpha2Code;
    }

    public void setAlpha2Code(String alpha2Code) {
        this.alpha2Code = alpha2Code;
    }

    public String getNumericCode() {
        return this.numericCode;
    }

    public void setNumericCode(String numericCode) {
        this.numericCode = numericCode;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCog() {
        return this.cog;
    }

    public void setCog(String cog) {
        this.cog = cog;
    }

    public String getPhonePrefix() {
        return this.phonePrefix;
    }

    public void setPhonePrefix(String phonePrefix) {
        this.phonePrefix = phonePrefix;
    }

    public EconomicArea getEconomicArea() {
        return this.economicArea;
    }

    public void setEconomicArea(EconomicArea economicArea) {
        this.economicArea = economicArea;
    }

    public Citizenship getCitizenship() {
        return this.citizenship;
    }

    public void setCitizenship(Citizenship citizenship) {
        this.citizenship = citizenship;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Country)) {
            return false;
        }
        Country other = (Country)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("alpha3Code", (Object)this.getAlpha3Code()).add("alpha2Code", (Object)this.getAlpha2Code()).add("numericCode", (Object)this.getNumericCode()).add("name", (Object)this.getName()).add("cog", (Object)this.getCog()).add("phonePrefix", (Object)this.getPhonePrefix()).omitNullValues().toString();
    }
}

