/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.AppBase;
import com.axelor.apps.base.db.Currency;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BASE_CURRENCY_CONVERSION_LINE", indexes={@Index(columnList="app_base"), @Index(columnList="start_currency"), @Index(columnList="end_currency")})
public class CurrencyConversionLine
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_CURRENCY_CONVERSION_LINE_SEQ")
    @SequenceGenerator(name="BASE_CURRENCY_CONVERSION_LINE_SEQ", sequenceName="BASE_CURRENCY_CONVERSION_LINE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Administration")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AppBase appBase;
    @Widget(title="Source Currency")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Currency startCurrency;
    @Widget(title="Destination Currency")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Currency endCurrency;
    @Widget(title="Exchange rate")
    @Digits(integer=12, fraction=8)
    private BigDecimal exchangeRate = BigDecimal.ZERO;
    @Widget(title="From Date")
    @NotNull
    private LocalDate fromDate;
    @Widget(title="To Date")
    private LocalDate toDate;
    @Widget(title="Variation")
    private String variations;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public AppBase getAppBase() {
        return this.appBase;
    }

    public void setAppBase(AppBase appBase) {
        this.appBase = appBase;
    }

    public Currency getStartCurrency() {
        return this.startCurrency;
    }

    public void setStartCurrency(Currency startCurrency) {
        this.startCurrency = startCurrency;
    }

    public Currency getEndCurrency() {
        return this.endCurrency;
    }

    public void setEndCurrency(Currency endCurrency) {
        this.endCurrency = endCurrency;
    }

    public BigDecimal getExchangeRate() {
        return this.exchangeRate == null ? BigDecimal.ZERO : this.exchangeRate;
    }

    public void setExchangeRate(BigDecimal exchangeRate) {
        this.exchangeRate = exchangeRate;
    }

    public LocalDate getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(LocalDate fromDate) {
        this.fromDate = fromDate;
    }

    public LocalDate getToDate() {
        return this.toDate;
    }

    public void setToDate(LocalDate toDate) {
        this.toDate = toDate;
    }

    public String getVariations() {
        return this.variations;
    }

    public void setVariations(String variations) {
        this.variations = variations;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CurrencyConversionLine)) {
            return false;
        }
        CurrencyConversionLine other = (CurrencyConversionLine)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("exchangeRate", (Object)this.getExchangeRate()).add("fromDate", (Object)this.getFromDate()).add("toDate", (Object)this.getToDate()).add("variations", (Object)this.getVariations()).omitNullValues().toString();
    }
}

