/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.WeeklyPlanning;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.time.LocalTime;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BASE_DAY_PLANNING", indexes={@Index(columnList="weekly_plann"), @Index(columnList="name")})
public class DayPlanning
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_DAY_PLANNING_SEQ")
    @SequenceGenerator(name="BASE_DAY_PLANNING_SEQ", sequenceName="BASE_DAY_PLANNING_SEQ", allocationSize=1)
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private WeeklyPlanning weeklyPlann;
    @Widget(title="Day", selection="hrs.weekly.day.select")
    @NameColumn
    @NotNull
    private String name;
    @Widget(title="1st Period From")
    private LocalTime morningFrom;
    @Widget(title="To")
    private LocalTime morningTo;
    @Widget(title="2nd Period From")
    private LocalTime afternoonFrom;
    @Widget(title="To")
    private LocalTime afternoonTo;
    @Widget(title="Seq.")
    private Integer sequence = 0;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public DayPlanning() {
    }

    public DayPlanning(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public WeeklyPlanning getWeeklyPlann() {
        return this.weeklyPlann;
    }

    public void setWeeklyPlann(WeeklyPlanning weeklyPlann) {
        this.weeklyPlann = weeklyPlann;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LocalTime getMorningFrom() {
        return this.morningFrom;
    }

    public void setMorningFrom(LocalTime morningFrom) {
        this.morningFrom = morningFrom;
    }

    public LocalTime getMorningTo() {
        return this.morningTo;
    }

    public void setMorningTo(LocalTime morningTo) {
        this.morningTo = morningTo;
    }

    public LocalTime getAfternoonFrom() {
        return this.afternoonFrom;
    }

    public void setAfternoonFrom(LocalTime afternoonFrom) {
        this.afternoonFrom = afternoonFrom;
    }

    public LocalTime getAfternoonTo() {
        return this.afternoonTo;
    }

    public void setAfternoonTo(LocalTime afternoonTo) {
        this.afternoonTo = afternoonTo;
    }

    public Integer getSequence() {
        return this.sequence == null ? 0 : this.sequence;
    }

    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DayPlanning)) {
            return false;
        }
        DayPlanning other = (DayPlanning)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("morningFrom", (Object)this.getMorningFrom()).add("morningTo", (Object)this.getMorningTo()).add("afternoonFrom", (Object)this.getAfternoonFrom()).add("afternoonTo", (Object)this.getAfternoonTo()).add("sequence", (Object)this.getSequence()).omitNullValues().toString();
    }
}

