/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.EventsPlanningLine;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="BASE_EVENTS_PLANNING", indexes={@Index(columnList="name")})
public class EventsPlanning
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_EVENTS_PLANNING_SEQ")
    @SequenceGenerator(name="BASE_EVENTS_PLANNING_SEQ", sequenceName="BASE_EVENTS_PLANNING_SEQ", allocationSize=1)
    private Long id;
    @NameColumn
    @NotNull
    private String name;
    @Widget(title="Public holidays list")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="eventsPlanning", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<EventsPlanningLine> eventsPlanningLineList;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public EventsPlanning() {
    }

    public EventsPlanning(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<EventsPlanningLine> getEventsPlanningLineList() {
        return this.eventsPlanningLineList;
    }

    public void setEventsPlanningLineList(List<EventsPlanningLine> eventsPlanningLineList) {
        this.eventsPlanningLineList = eventsPlanningLineList;
    }

    public void addEventsPlanningLineListItem(EventsPlanningLine item) {
        if (this.getEventsPlanningLineList() == null) {
            this.setEventsPlanningLineList(new ArrayList<EventsPlanningLine>());
        }
        this.getEventsPlanningLineList().add(item);
        item.setEventsPlanning(this);
    }

    public void removeEventsPlanningLineListItem(EventsPlanningLine item) {
        if (this.getEventsPlanningLineList() == null) {
            return;
        }
        this.getEventsPlanningLineList().remove((Object)item);
    }

    public void clearEventsPlanningLineList() {
        if (this.getEventsPlanningLineList() != null) {
            this.getEventsPlanningLineList().clear();
        }
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EventsPlanning)) {
            return false;
        }
        EventsPlanning other = (EventsPlanning)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).omitNullValues().toString();
    }
}

