/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.EventsPlanning;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.time.LocalDate;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="BASE_EVENTS_PLANNING_LINE", indexes={@Index(columnList="events_planning")})
public class EventsPlanningLine
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_EVENTS_PLANNING_LINE_SEQ")
    @SequenceGenerator(name="BASE_EVENTS_PLANNING_LINE_SEQ", sequenceName="BASE_EVENTS_PLANNING_LINE_SEQ", allocationSize=1)
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private EventsPlanning eventsPlanning;
    @Widget(title="Year")
    @NotNull
    private Integer year = 0;
    @Widget(title="Date")
    @NotNull
    @Column(name="date_val")
    private LocalDate date;
    @Widget(title="Description")
    private String description;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public EventsPlanning getEventsPlanning() {
        return this.eventsPlanning;
    }

    public void setEventsPlanning(EventsPlanning eventsPlanning) {
        this.eventsPlanning = eventsPlanning;
    }

    public Integer getYear() {
        return this.year == null ? 0 : this.year;
    }

    public void setYear(Integer year) {
        this.year = year;
    }

    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EventsPlanningLine)) {
            return false;
        }
        EventsPlanningLine other = (EventsPlanningLine)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("year", (Object)this.getYear()).add("date", (Object)this.getDate()).add("description", (Object)this.getDescription()).omitNullValues().toString();
    }
}

