/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.FileTab;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaField;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BASE_FILE_FIELD", indexes={@Index(columnList="import_field"), @Index(columnList="fullName"), @Index(columnList="file_tab")})
public class FileField
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_FILE_FIELD_SEQ")
    @SequenceGenerator(name="BASE_FILE_FIELD_SEQ", sequenceName="BASE_FILE_FIELD_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Sequence")
    private Integer sequence = 0;
    @Widget(title="Column title")
    private String columnTitle;
    @Widget(title="First line")
    private String firstLine;
    @Widget(title="Second line")
    private String secondLine;
    @Widget(title="Third line")
    private String thirdLine;
    @Widget(title="Import field")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaField importField;
    @Widget(title="Sub import field")
    private String subImportField;
    @Widget(title="Name", readonly=true)
    @NameColumn
    private String fullName;
    @Widget(title="Date format")
    private String dateFormat;
    @Widget(title="Import type", selection="file.field.import.type.select")
    private Integer importType = 0;
    @Widget(title="Expression")
    private String expression;
    @Widget(title="Split by")
    @Size(max=1)
    private String splitBy;
    @Widget(title="Don't import if")
    private String noImportIf;
    @Widget(title="For select use", selection="file.field.for.select.use.select")
    private Integer forSelectUse = 0;
    @Widget(title="Default if not found")
    private String defaultIfNotFound;
    @Widget(title="FileTab")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private FileTab fileTab;
    @Widget(title="Match with file")
    private Boolean isMatchWithFile = Boolean.FALSE;
    @Widget(title="Target type")
    private String targetType;
    @Widget(title="Relationship")
    private String relationship;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getSequence() {
        return this.sequence == null ? 0 : this.sequence;
    }

    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }

    public String getColumnTitle() {
        return this.columnTitle;
    }

    public void setColumnTitle(String columnTitle) {
        this.columnTitle = columnTitle;
    }

    public String getFirstLine() {
        return this.firstLine;
    }

    public void setFirstLine(String firstLine) {
        this.firstLine = firstLine;
    }

    public String getSecondLine() {
        return this.secondLine;
    }

    public void setSecondLine(String secondLine) {
        this.secondLine = secondLine;
    }

    public String getThirdLine() {
        return this.thirdLine;
    }

    public void setThirdLine(String thirdLine) {
        this.thirdLine = thirdLine;
    }

    public MetaField getImportField() {
        return this.importField;
    }

    public void setImportField(MetaField importField) {
        this.importField = importField;
    }

    public String getSubImportField() {
        return this.subImportField;
    }

    public void setSubImportField(String subImportField) {
        this.subImportField = subImportField;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public Integer getImportType() {
        return this.importType == null ? 0 : this.importType;
    }

    public void setImportType(Integer importType) {
        this.importType = importType;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getSplitBy() {
        return this.splitBy;
    }

    public void setSplitBy(String splitBy) {
        this.splitBy = splitBy;
    }

    public String getNoImportIf() {
        return this.noImportIf;
    }

    public void setNoImportIf(String noImportIf) {
        this.noImportIf = noImportIf;
    }

    public Integer getForSelectUse() {
        return this.forSelectUse == null ? 0 : this.forSelectUse;
    }

    public void setForSelectUse(Integer forSelectUse) {
        this.forSelectUse = forSelectUse;
    }

    public String getDefaultIfNotFound() {
        return this.defaultIfNotFound;
    }

    public void setDefaultIfNotFound(String defaultIfNotFound) {
        this.defaultIfNotFound = defaultIfNotFound;
    }

    public FileTab getFileTab() {
        return this.fileTab;
    }

    public void setFileTab(FileTab fileTab) {
        this.fileTab = fileTab;
    }

    public Boolean getIsMatchWithFile() {
        return this.isMatchWithFile == null ? Boolean.FALSE : this.isMatchWithFile;
    }

    public void setIsMatchWithFile(Boolean isMatchWithFile) {
        this.isMatchWithFile = isMatchWithFile;
    }

    public String getTargetType() {
        return this.targetType;
    }

    public void setTargetType(String targetType) {
        this.targetType = targetType;
    }

    public String getRelationship() {
        return this.relationship;
    }

    public void setRelationship(String relationship) {
        this.relationship = relationship;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FileField)) {
            return false;
        }
        FileField other = (FileField)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("sequence", (Object)this.getSequence()).add("columnTitle", (Object)this.getColumnTitle()).add("firstLine", (Object)this.getFirstLine()).add("secondLine", (Object)this.getSecondLine()).add("thirdLine", (Object)this.getThirdLine()).add("subImportField", (Object)this.getSubImportField()).add("fullName", (Object)this.getFullName()).add("dateFormat", (Object)this.getDateFormat()).add("importType", (Object)this.getImportType()).add("expression", (Object)this.getExpression()).add("splitBy", (Object)this.getSplitBy()).omitNullValues().toString();
    }
}

