/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.ICalendar;
import com.axelor.apps.base.db.ICalendarUser;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Track;
import com.axelor.db.annotations.TrackEvent;
import com.axelor.db.annotations.TrackField;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="ICAL_EVENT", indexes={@Index(columnList="subject"), @Index(columnList="calendar"), @Index(columnList="organizer"), @Index(columnList="user_id")})
@Track(fields={@TrackField(name="subject"), @TrackField(name="startDateTime"), @TrackField(name="endDateTime", on={TrackEvent.UPDATE}), @TrackField(name="computedAttendeeList")}, subscribe=true)
public class ICalendarEvent
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ICAL_EVENT_SEQ")
    @SequenceGenerator(name="ICAL_EVENT_SEQ", sequenceName="ICAL_EVENT_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="UID")
    @Column(name="calendar_uid", unique=true)
    private String uid;
    @Widget(title="URL")
    private String url;
    @Widget(title="Subject")
    @NameColumn
    @NotNull
    private String subject;
    @Widget(title="Description")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String description;
    @Widget(title="Status")
    private String status;
    @Widget(title="Start date")
    @NotNull
    private LocalDateTime startDateTime;
    @Widget(title="End date")
    @NotNull
    private LocalDateTime endDateTime;
    @Widget(title="All day")
    private Boolean allDay = Boolean.FALSE;
    @Widget(title="Location")
    private String location;
    @Widget(title="Geo. coordinates")
    private String geo;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ICalendar calendar;
    @Widget(title="Organizer")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ICalendarUser organizer;
    @Widget(title="Attendees")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="event", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private List<ICalendarUser> attendees;
    @Widget(title="Attendees")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String computedAttendeeList;
    @Widget(title="Visibility", selection="i.cal.event.visibility.select")
    private Integer visibilitySelect = 1;
    @Widget(title="Availability", selection="i.cal.event.disponibility.select")
    private Integer disponibilitySelect = 1;
    private String subjectTeam;
    @Widget(title="Type", selection="icalendar.event.type.select")
    @NotNull
    private Integer typeSelect = 0;
    @Widget(title="Assigned to")
    @JoinColumn(name="user_id")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User user;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public LocalDateTime getStartDateTime() {
        return this.startDateTime;
    }

    public void setStartDateTime(LocalDateTime startDateTime) {
        this.startDateTime = startDateTime;
    }

    public LocalDateTime getEndDateTime() {
        return this.endDateTime;
    }

    public void setEndDateTime(LocalDateTime endDateTime) {
        this.endDateTime = endDateTime;
    }

    public Boolean getAllDay() {
        return this.allDay == null ? Boolean.FALSE : this.allDay;
    }

    public void setAllDay(Boolean allDay) {
        this.allDay = allDay;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getGeo() {
        return this.geo;
    }

    public void setGeo(String geo) {
        this.geo = geo;
    }

    public ICalendar getCalendar() {
        return this.calendar;
    }

    public void setCalendar(ICalendar calendar) {
        this.calendar = calendar;
    }

    public ICalendarUser getOrganizer() {
        return this.organizer;
    }

    public void setOrganizer(ICalendarUser organizer) {
        this.organizer = organizer;
    }

    public List<ICalendarUser> getAttendees() {
        return this.attendees;
    }

    public void setAttendees(List<ICalendarUser> attendees) {
        this.attendees = attendees;
    }

    public void addAttendee(ICalendarUser item) {
        if (this.getAttendees() == null) {
            this.setAttendees(new ArrayList<ICalendarUser>());
        }
        this.getAttendees().add(item);
        item.setEvent(this);
    }

    public void removeAttendee(ICalendarUser item) {
        if (this.getAttendees() == null) {
            return;
        }
        this.getAttendees().remove((Object)item);
        item.setEvent(null);
    }

    public void clearAttendees() {
        if (this.getAttendees() != null) {
            for (ICalendarUser item : this.getAttendees()) {
                item.setEvent(null);
            }
            this.getAttendees().clear();
        }
    }

    public String getComputedAttendeeList() {
        return this.computedAttendeeList;
    }

    public void setComputedAttendeeList(String computedAttendeeList) {
        this.computedAttendeeList = computedAttendeeList;
    }

    public Integer getVisibilitySelect() {
        return this.visibilitySelect == null ? 0 : this.visibilitySelect;
    }

    public void setVisibilitySelect(Integer visibilitySelect) {
        this.visibilitySelect = visibilitySelect;
    }

    public Integer getDisponibilitySelect() {
        return this.disponibilitySelect == null ? 0 : this.disponibilitySelect;
    }

    public void setDisponibilitySelect(Integer disponibilitySelect) {
        this.disponibilitySelect = disponibilitySelect;
    }

    public String getSubjectTeam() {
        return this.subjectTeam;
    }

    public void setSubjectTeam(String subjectTeam) {
        this.subjectTeam = subjectTeam;
    }

    public Integer getTypeSelect() {
        return this.typeSelect == null ? 0 : this.typeSelect;
    }

    public void setTypeSelect(Integer typeSelect) {
        this.typeSelect = typeSelect;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ICalendarEvent)) {
            return false;
        }
        ICalendarEvent other = (ICalendarEvent)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("uid", (Object)this.getUid()).add("url", (Object)this.getUrl()).add("subject", (Object)this.getSubject()).add("status", (Object)this.getStatus()).add("startDateTime", (Object)this.getStartDateTime()).add("endDateTime", (Object)this.getEndDateTime()).add("allDay", (Object)this.getAllDay()).add("location", (Object)this.getLocation()).add("geo", (Object)this.getGeo()).add("visibilitySelect", (Object)this.getVisibilitySelect()).add("disponibilitySelect", (Object)this.getDisponibilitySelect()).omitNullValues().toString();
    }
}

