/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.ImportHistory;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaFile;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BASE_IMPORT_CONFIGURATION", indexes={@Index(columnList="name"), @Index(columnList="user_id"), @Index(columnList="bind_meta_file"), @Index(columnList="data_meta_file")})
public class ImportConfiguration
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_IMPORT_CONFIGURATION_SEQ")
    @SequenceGenerator(name="BASE_IMPORT_CONFIGURATION_SEQ", sequenceName="BASE_IMPORT_CONFIGURATION_SEQ", allocationSize=1)
    private Long id;
    @NameColumn
    private String name;
    @Widget(title="Import type", selection="iimport.type.select")
    @NotNull
    private String typeSelect = "csv";
    @Widget(title="User")
    @NotNull
    @JoinColumn(name="user_id")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User user;
    @Widget(title="Binding file")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaFile bindMetaFile;
    @Widget(title="Data file")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaFile dataMetaFile;
    @Widget(title="Historical")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="importConfiguration", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ImportHistory> importHistoryList;
    @Widget(title="Description")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String description;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public ImportConfiguration() {
    }

    public ImportConfiguration(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTypeSelect() {
        return this.typeSelect;
    }

    public void setTypeSelect(String typeSelect) {
        this.typeSelect = typeSelect;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public MetaFile getBindMetaFile() {
        return this.bindMetaFile;
    }

    public void setBindMetaFile(MetaFile bindMetaFile) {
        this.bindMetaFile = bindMetaFile;
    }

    public MetaFile getDataMetaFile() {
        return this.dataMetaFile;
    }

    public void setDataMetaFile(MetaFile dataMetaFile) {
        this.dataMetaFile = dataMetaFile;
    }

    public List<ImportHistory> getImportHistoryList() {
        return this.importHistoryList;
    }

    public void setImportHistoryList(List<ImportHistory> importHistoryList) {
        this.importHistoryList = importHistoryList;
    }

    public void addImportHistoryListItem(ImportHistory item) {
        if (this.getImportHistoryList() == null) {
            this.setImportHistoryList(new ArrayList<ImportHistory>());
        }
        this.getImportHistoryList().add(item);
        item.setImportConfiguration(this);
    }

    public void removeImportHistoryListItem(ImportHistory item) {
        if (this.getImportHistoryList() == null) {
            return;
        }
        this.getImportHistoryList().remove((Object)item);
    }

    public void clearImportHistoryList() {
        if (this.getImportHistoryList() != null) {
            this.getImportHistoryList().clear();
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ImportConfiguration)) {
            return false;
        }
        ImportConfiguration other = (ImportConfiguration)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("typeSelect", (Object)this.getTypeSelect()).omitNullValues().toString();
    }
}

