/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.ImportConfiguration;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaFile;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BASE_IMPORT_HISTORY", indexes={@Index(columnList="import_configuration"), @Index(columnList="user_id"), @Index(columnList="data_meta_file"), @Index(columnList="log_meta_file")})
public class ImportHistory
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_IMPORT_HISTORY_SEQ")
    @SequenceGenerator(name="BASE_IMPORT_HISTORY_SEQ", sequenceName="BASE_IMPORT_HISTORY_SEQ", allocationSize=1)
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ImportConfiguration importConfiguration;
    @Widget(title="User")
    @NotNull
    @JoinColumn(name="user_id")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User user;
    @Widget(title="Data(s)")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaFile dataMetaFile;
    @Widget(title="Log")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaFile logMetaFile;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public ImportHistory() {
    }

    public ImportHistory(User user, MetaFile dataMetaFile) {
        this.user = user;
        this.dataMetaFile = dataMetaFile;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public ImportConfiguration getImportConfiguration() {
        return this.importConfiguration;
    }

    public void setImportConfiguration(ImportConfiguration importConfiguration) {
        this.importConfiguration = importConfiguration;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public MetaFile getDataMetaFile() {
        return this.dataMetaFile;
    }

    public void setDataMetaFile(MetaFile dataMetaFile) {
        this.dataMetaFile = dataMetaFile;
    }

    public MetaFile getLogMetaFile() {
        return this.logMetaFile;
    }

    public void setLogMetaFile(MetaFile logMetaFile) {
        this.logMetaFile = logMetaFile;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ImportHistory)) {
            return false;
        }
        ImportHistory other = (ImportHistory)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).omitNullValues().toString();
    }
}

