/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.Batch;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.message.db.Template;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BASE_MAIL_BATCH", indexes={@Index(columnList="company"), @Index(columnList="template")})
public class MailBatch
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_MAIL_BATCH_SEQ")
    @SequenceGenerator(name="BASE_MAIL_BATCH_SEQ", sequenceName="BASE_MAIL_BATCH_SEQ", allocationSize=1)
    private Long id;
    @HashKey
    @Widget(title="Code")
    @NameColumn
    @Column(unique=true)
    private String code;
    @Widget(title="Action", selection="base.batch.action.select")
    @NotNull
    private Integer actionSelect = 1;
    @Widget(title="Company")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Template")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Template template;
    @Widget(title="Description")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String description;
    @Widget(title="Batchs")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="mailBatch", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<Batch> batchList;
    @Widget(title="Subject")
    private String subject;
    @Widget(title="Content")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String content;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public MailBatch() {
    }

    public MailBatch(String subject, String content) {
        this.subject = subject;
        this.content = content;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Integer getActionSelect() {
        return this.actionSelect == null ? 0 : this.actionSelect;
    }

    public void setActionSelect(Integer actionSelect) {
        this.actionSelect = actionSelect;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public Template getTemplate() {
        return this.template;
    }

    public void setTemplate(Template template) {
        this.template = template;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<Batch> getBatchList() {
        return this.batchList;
    }

    public void setBatchList(List<Batch> batchList) {
        this.batchList = batchList;
    }

    public void addBatchListItem(Batch item) {
        if (this.getBatchList() == null) {
            this.setBatchList(new ArrayList<Batch>());
        }
        this.getBatchList().add(item);
        item.setMailBatch(this);
    }

    public void removeBatchListItem(Batch item) {
        if (this.getBatchList() == null) {
            return;
        }
        this.getBatchList().remove((Object)item);
    }

    public void clearBatchList() {
        if (this.getBatchList() != null) {
            this.getBatchList().clear();
        }
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MailBatch)) {
            return false;
        }
        MailBatch other = (MailBatch)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals(this.getCode(), other.getCode());
    }

    public int hashCode() {
        return Objects.hash(1668348835, this.getCode());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("code", (Object)this.getCode()).add("actionSelect", (Object)this.getActionSelect()).add("subject", (Object)this.getSubject()).omitNullValues().toString();
    }
}

