/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Track;
import com.axelor.db.annotations.TrackEvent;
import com.axelor.db.annotations.TrackField;
import com.axelor.db.annotations.TrackMessage;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BASE_MAILING_LIST_MESSAGE")
@Track(fields={@TrackField(name="subject"), @TrackField(name="description")}, messages={@TrackMessage(message="Mailing list created", condition="true", on={TrackEvent.CREATE}), @TrackMessage(message="Mailing list updated", condition="true", on={TrackEvent.UPDATE})}, files=true)
public class MailingListMessage
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_MAILING_LIST_MESSAGE_SEQ")
    @SequenceGenerator(name="BASE_MAILING_LIST_MESSAGE_SEQ", sequenceName="BASE_MAILING_LIST_MESSAGE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Image")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    private byte[] image;
    @Widget(title="Subject")
    private String subject;
    @Widget(title="Description")
    private String description;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public byte[] getImage() {
        return this.image;
    }

    public void setImage(byte[] image) {
        this.image = image;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MailingListMessage)) {
            return false;
        }
        MailingListMessage other = (MailingListMessage)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("subject", (Object)this.getSubject()).add("description", (Object)this.getDescription()).omitNullValues().toString();
    }
}

