/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.PriceList;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BASE_PARTNER_PRICE_LIST", indexes={@Index(columnList="label")})
public class PartnerPriceList
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_PARTNER_PRICE_LIST_SEQ")
    @SequenceGenerator(name="BASE_PARTNER_PRICE_LIST_SEQ", sequenceName="BASE_PARTNER_PRICE_LIST_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Label")
    @NameColumn
    @NotNull
    private String label;
    @Widget(title="Type", selection="base.price.list.type.select")
    @NotNull
    private Integer typeSelect = 0;
    @Widget(title="Price lists")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<PriceList> priceListSet;
    @Widget(title="Exclusive")
    private Boolean isExclusive = Boolean.FALSE;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Integer getTypeSelect() {
        return this.typeSelect == null ? 0 : this.typeSelect;
    }

    public void setTypeSelect(Integer typeSelect) {
        this.typeSelect = typeSelect;
    }

    public Set<PriceList> getPriceListSet() {
        return this.priceListSet;
    }

    public void setPriceListSet(Set<PriceList> priceListSet) {
        this.priceListSet = priceListSet;
    }

    public void addPriceListSetItem(PriceList item) {
        if (this.getPriceListSet() == null) {
            this.setPriceListSet(new HashSet<PriceList>());
        }
        this.getPriceListSet().add(item);
    }

    public void removePriceListSetItem(PriceList item) {
        if (this.getPriceListSet() == null) {
            return;
        }
        this.getPriceListSet().remove((Object)item);
    }

    public void clearPriceListSet() {
        if (this.getPriceListSet() != null) {
            this.getPriceListSet().clear();
        }
    }

    public Boolean getIsExclusive() {
        return this.isExclusive == null ? Boolean.FALSE : this.isExclusive;
    }

    public void setIsExclusive(Boolean isExclusive) {
        this.isExclusive = isExclusive;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PartnerPriceList)) {
            return false;
        }
        PartnerPriceList other = (PartnerPriceList)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("label", (Object)this.getLabel()).add("typeSelect", (Object)this.getTypeSelect()).add("isExclusive", (Object)this.getIsExclusive()).omitNullValues().toString();
    }
}

