/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.account.db.AccountManagement;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="BASE_PRODUCT_FAMILY", indexes={@Index(columnList="name")})
public class ProductFamily
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_PRODUCT_FAMILY_SEQ")
    @SequenceGenerator(name="BASE_PRODUCT_FAMILY_SEQ", sequenceName="BASE_PRODUCT_FAMILY_SEQ", allocationSize=1)
    private Long id;
    @HashKey
    @Widget(title="Family Code")
    @NotNull
    @Column(unique=true)
    private String code;
    @Widget(title="Family Name")
    @NotNull
    private String name;
    @Widget(title="Accounts Configurations")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="productFamily", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<AccountManagement> accountManagementList;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public ProductFamily() {
    }

    public ProductFamily(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<AccountManagement> getAccountManagementList() {
        return this.accountManagementList;
    }

    public void setAccountManagementList(List<AccountManagement> accountManagementList) {
        this.accountManagementList = accountManagementList;
    }

    public void addAccountManagementListItem(AccountManagement item) {
        if (this.getAccountManagementList() == null) {
            this.setAccountManagementList(new ArrayList<AccountManagement>());
        }
        this.getAccountManagementList().add(item);
        item.setProductFamily(this);
    }

    public void removeAccountManagementListItem(AccountManagement item) {
        if (this.getAccountManagementList() == null) {
            return;
        }
        this.getAccountManagementList().remove((Object)item);
    }

    public void clearAccountManagementList() {
        if (this.getAccountManagementList() != null) {
            this.getAccountManagementList().clear();
        }
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ProductFamily)) {
            return false;
        }
        ProductFamily other = (ProductFamily)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals(this.getCode(), other.getCode());
    }

    public int hashCode() {
        return Objects.hash(1452446995, this.getCode());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("code", (Object)this.getCode()).add("name", (Object)this.getName()).omitNullValues().toString();
    }
}

