/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.ProductVariantAttr;
import com.axelor.apps.base.db.ProductVariantValue;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.VirtualColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@DynamicInsert
@DynamicUpdate
@Table(name="BASE_PRODUCT_VARIANT", indexes={@Index(columnList="product_variant_attr1"), @Index(columnList="product_variant_attr2"), @Index(columnList="product_variant_attr3"), @Index(columnList="product_variant_attr4"), @Index(columnList="product_variant_value1"), @Index(columnList="product_variant_value2"), @Index(columnList="product_variant_value3"), @Index(columnList="product_variant_value4"), @Index(columnList="name")})
public class ProductVariant
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_PRODUCT_VARIANT_SEQ")
    @SequenceGenerator(name="BASE_PRODUCT_VARIANT_SEQ", sequenceName="BASE_PRODUCT_VARIANT_SEQ", allocationSize=1)
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ProductVariantAttr productVariantAttr1;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ProductVariantAttr productVariantAttr2;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ProductVariantAttr productVariantAttr3;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ProductVariantAttr productVariantAttr4;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ProductVariantValue productVariantValue1;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ProductVariantValue productVariantValue2;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ProductVariantValue productVariantValue3;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ProductVariantValue productVariantValue4;
    @Widget(title="Use for stock only")
    private Boolean usedForStock = Boolean.FALSE;
    @Widget(title="Name")
    @VirtualColumn
    @Access(value=AccessType.PROPERTY)
    @NotNull
    private String name;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public ProductVariant() {
    }

    public ProductVariant(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public ProductVariantAttr getProductVariantAttr1() {
        return this.productVariantAttr1;
    }

    public void setProductVariantAttr1(ProductVariantAttr productVariantAttr1) {
        this.productVariantAttr1 = productVariantAttr1;
    }

    public ProductVariantAttr getProductVariantAttr2() {
        return this.productVariantAttr2;
    }

    public void setProductVariantAttr2(ProductVariantAttr productVariantAttr2) {
        this.productVariantAttr2 = productVariantAttr2;
    }

    public ProductVariantAttr getProductVariantAttr3() {
        return this.productVariantAttr3;
    }

    public void setProductVariantAttr3(ProductVariantAttr productVariantAttr3) {
        this.productVariantAttr3 = productVariantAttr3;
    }

    public ProductVariantAttr getProductVariantAttr4() {
        return this.productVariantAttr4;
    }

    public void setProductVariantAttr4(ProductVariantAttr productVariantAttr4) {
        this.productVariantAttr4 = productVariantAttr4;
    }

    public ProductVariantValue getProductVariantValue1() {
        return this.productVariantValue1;
    }

    public void setProductVariantValue1(ProductVariantValue productVariantValue1) {
        this.productVariantValue1 = productVariantValue1;
    }

    public ProductVariantValue getProductVariantValue2() {
        return this.productVariantValue2;
    }

    public void setProductVariantValue2(ProductVariantValue productVariantValue2) {
        this.productVariantValue2 = productVariantValue2;
    }

    public ProductVariantValue getProductVariantValue3() {
        return this.productVariantValue3;
    }

    public void setProductVariantValue3(ProductVariantValue productVariantValue3) {
        this.productVariantValue3 = productVariantValue3;
    }

    public ProductVariantValue getProductVariantValue4() {
        return this.productVariantValue4;
    }

    public void setProductVariantValue4(ProductVariantValue productVariantValue4) {
        this.productVariantValue4 = productVariantValue4;
    }

    public Boolean getUsedForStock() {
        return this.usedForStock == null ? Boolean.FALSE : this.usedForStock;
    }

    public void setUsedForStock(Boolean usedForStock) {
        this.usedForStock = usedForStock;
    }

    public String getName() {
        try {
            this.name = this.computeName();
        }
        catch (NullPointerException e) {
            Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
            logger.error("NPE in function field: getName()", (Throwable)e);
        }
        return this.name;
    }

    protected String computeName() {
        String name = "";
        if (this.productVariantAttr1 != null && this.productVariantValue1 != null) {
            name = name + this.productVariantAttr1.getName() + " : " + this.productVariantValue1.getName();
        }
        if (this.productVariantAttr2 != null && this.productVariantValue2 != null) {
            if (!name.equals("")) {
                name = name + ", ";
            }
            name = name + this.productVariantAttr2.getName() + " : " + this.productVariantValue2.getName();
        }
        if (this.productVariantAttr3 != null && this.productVariantValue3 != null) {
            if (!name.equals("")) {
                name = name + ", ";
            }
            name = name + this.productVariantAttr3.getName() + " : " + this.productVariantValue3.getName();
        }
        if (this.productVariantAttr4 != null && this.productVariantValue4 != null) {
            if (!name.equals("")) {
                name = name + ", ";
            }
            name = name + this.productVariantAttr4.getName() + " : " + this.productVariantValue4.getName();
        }
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ProductVariant)) {
            return false;
        }
        ProductVariant other = (ProductVariant)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("usedForStock", (Object)this.getUsedForStock()).omitNullValues().toString();
    }
}

