/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.ProductVariantAttr;
import com.axelor.apps.base.db.ProductVariantValue;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.VirtualColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@DynamicInsert
@DynamicUpdate
@Table(name="BASE_PRODUCT_VARIANT_CONFIG", indexes={@Index(columnList="product_variant_attr1"), @Index(columnList="product_variant_attr2"), @Index(columnList="product_variant_attr3"), @Index(columnList="product_variant_attr4"), @Index(columnList="name")})
public class ProductVariantConfig
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_PRODUCT_VARIANT_CONFIG_SEQ")
    @SequenceGenerator(name="BASE_PRODUCT_VARIANT_CONFIG_SEQ", sequenceName="BASE_PRODUCT_VARIANT_CONFIG_SEQ", allocationSize=1)
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ProductVariantAttr productVariantAttr1;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ProductVariantAttr productVariantAttr2;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ProductVariantAttr productVariantAttr3;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ProductVariantAttr productVariantAttr4;
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<ProductVariantValue> productVariantValue1Set;
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<ProductVariantValue> productVariantValue2Set;
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<ProductVariantValue> productVariantValue3Set;
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<ProductVariantValue> productVariantValue4Set;
    @Widget(title="Name")
    @VirtualColumn
    @Access(value=AccessType.PROPERTY)
    private String name;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public ProductVariantConfig() {
    }

    public ProductVariantConfig(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public ProductVariantAttr getProductVariantAttr1() {
        return this.productVariantAttr1;
    }

    public void setProductVariantAttr1(ProductVariantAttr productVariantAttr1) {
        this.productVariantAttr1 = productVariantAttr1;
    }

    public ProductVariantAttr getProductVariantAttr2() {
        return this.productVariantAttr2;
    }

    public void setProductVariantAttr2(ProductVariantAttr productVariantAttr2) {
        this.productVariantAttr2 = productVariantAttr2;
    }

    public ProductVariantAttr getProductVariantAttr3() {
        return this.productVariantAttr3;
    }

    public void setProductVariantAttr3(ProductVariantAttr productVariantAttr3) {
        this.productVariantAttr3 = productVariantAttr3;
    }

    public ProductVariantAttr getProductVariantAttr4() {
        return this.productVariantAttr4;
    }

    public void setProductVariantAttr4(ProductVariantAttr productVariantAttr4) {
        this.productVariantAttr4 = productVariantAttr4;
    }

    public Set<ProductVariantValue> getProductVariantValue1Set() {
        return this.productVariantValue1Set;
    }

    public void setProductVariantValue1Set(Set<ProductVariantValue> productVariantValue1Set) {
        this.productVariantValue1Set = productVariantValue1Set;
    }

    public void addProductVariantValue1SetItem(ProductVariantValue item) {
        if (this.getProductVariantValue1Set() == null) {
            this.setProductVariantValue1Set(new HashSet<ProductVariantValue>());
        }
        this.getProductVariantValue1Set().add(item);
    }

    public void removeProductVariantValue1SetItem(ProductVariantValue item) {
        if (this.getProductVariantValue1Set() == null) {
            return;
        }
        this.getProductVariantValue1Set().remove((Object)item);
    }

    public void clearProductVariantValue1Set() {
        if (this.getProductVariantValue1Set() != null) {
            this.getProductVariantValue1Set().clear();
        }
    }

    public Set<ProductVariantValue> getProductVariantValue2Set() {
        return this.productVariantValue2Set;
    }

    public void setProductVariantValue2Set(Set<ProductVariantValue> productVariantValue2Set) {
        this.productVariantValue2Set = productVariantValue2Set;
    }

    public void addProductVariantValue2SetItem(ProductVariantValue item) {
        if (this.getProductVariantValue2Set() == null) {
            this.setProductVariantValue2Set(new HashSet<ProductVariantValue>());
        }
        this.getProductVariantValue2Set().add(item);
    }

    public void removeProductVariantValue2SetItem(ProductVariantValue item) {
        if (this.getProductVariantValue2Set() == null) {
            return;
        }
        this.getProductVariantValue2Set().remove((Object)item);
    }

    public void clearProductVariantValue2Set() {
        if (this.getProductVariantValue2Set() != null) {
            this.getProductVariantValue2Set().clear();
        }
    }

    public Set<ProductVariantValue> getProductVariantValue3Set() {
        return this.productVariantValue3Set;
    }

    public void setProductVariantValue3Set(Set<ProductVariantValue> productVariantValue3Set) {
        this.productVariantValue3Set = productVariantValue3Set;
    }

    public void addProductVariantValue3SetItem(ProductVariantValue item) {
        if (this.getProductVariantValue3Set() == null) {
            this.setProductVariantValue3Set(new HashSet<ProductVariantValue>());
        }
        this.getProductVariantValue3Set().add(item);
    }

    public void removeProductVariantValue3SetItem(ProductVariantValue item) {
        if (this.getProductVariantValue3Set() == null) {
            return;
        }
        this.getProductVariantValue3Set().remove((Object)item);
    }

    public void clearProductVariantValue3Set() {
        if (this.getProductVariantValue3Set() != null) {
            this.getProductVariantValue3Set().clear();
        }
    }

    public Set<ProductVariantValue> getProductVariantValue4Set() {
        return this.productVariantValue4Set;
    }

    public void setProductVariantValue4Set(Set<ProductVariantValue> productVariantValue4Set) {
        this.productVariantValue4Set = productVariantValue4Set;
    }

    public void addProductVariantValue4SetItem(ProductVariantValue item) {
        if (this.getProductVariantValue4Set() == null) {
            this.setProductVariantValue4Set(new HashSet<ProductVariantValue>());
        }
        this.getProductVariantValue4Set().add(item);
    }

    public void removeProductVariantValue4SetItem(ProductVariantValue item) {
        if (this.getProductVariantValue4Set() == null) {
            return;
        }
        this.getProductVariantValue4Set().remove((Object)item);
    }

    public void clearProductVariantValue4Set() {
        if (this.getProductVariantValue4Set() != null) {
            this.getProductVariantValue4Set().clear();
        }
    }

    public String getName() {
        try {
            this.name = this.computeName();
        }
        catch (NullPointerException e) {
            Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
            logger.error("NPE in function field: getName()", (Throwable)e);
        }
        return this.name;
    }

    protected String computeName() {
        String name = "";
        if (this.productVariantAttr1 != null) {
            name = name + this.productVariantAttr1.getName();
        }
        if (this.productVariantAttr2 != null) {
            if (!name.equals("")) {
                name = name + ", ";
            }
            name = name + this.productVariantAttr2.getName();
        }
        if (this.productVariantAttr3 != null) {
            if (!name.equals("")) {
                name = name + ", ";
            }
            name = name + this.productVariantAttr3.getName();
        }
        if (this.productVariantAttr4 != null) {
            if (!name.equals("")) {
                name = name + ", ";
            }
            name = name + this.productVariantAttr4.getName();
        }
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ProductVariantConfig)) {
            return false;
        }
        ProductVariantConfig other = (ProductVariantConfig)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).omitNullValues().toString();
    }
}

