/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.RoutingAction;
import com.axelor.apps.base.db.RoutingRule;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BASE_ROUTING", indexes={@Index(columnList="name"), @Index(columnList="code")})
public class Routing
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_ROUTING_SEQ")
    @SequenceGenerator(name="BASE_ROUTING_SEQ", sequenceName="BASE_ROUTING_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Name")
    @NotNull
    private String name;
    @Widget(title="Code")
    @NotNull
    private String code;
    @Widget(title="Priority")
    private Integer priority = 0;
    @Widget(title="Active")
    private Boolean isActive = Boolean.FALSE;
    @Widget(title="Routing rules")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="routing", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<RoutingRule> routingRuleList;
    @Widget(title="Routing actions")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="routing", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<RoutingAction> routingActionList;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Routing() {
    }

    public Routing(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Integer getPriority() {
        return this.priority == null ? 0 : this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public Boolean getIsActive() {
        return this.isActive == null ? Boolean.FALSE : this.isActive;
    }

    public void setIsActive(Boolean isActive) {
        this.isActive = isActive;
    }

    public List<RoutingRule> getRoutingRuleList() {
        return this.routingRuleList;
    }

    public void setRoutingRuleList(List<RoutingRule> routingRuleList) {
        this.routingRuleList = routingRuleList;
    }

    public void addRoutingRuleListItem(RoutingRule item) {
        if (this.getRoutingRuleList() == null) {
            this.setRoutingRuleList(new ArrayList<RoutingRule>());
        }
        this.getRoutingRuleList().add(item);
        item.setRouting(this);
    }

    public void removeRoutingRuleListItem(RoutingRule item) {
        if (this.getRoutingRuleList() == null) {
            return;
        }
        this.getRoutingRuleList().remove((Object)item);
    }

    public void clearRoutingRuleList() {
        if (this.getRoutingRuleList() != null) {
            this.getRoutingRuleList().clear();
        }
    }

    public List<RoutingAction> getRoutingActionList() {
        return this.routingActionList;
    }

    public void setRoutingActionList(List<RoutingAction> routingActionList) {
        this.routingActionList = routingActionList;
    }

    public void addRoutingActionListItem(RoutingAction item) {
        if (this.getRoutingActionList() == null) {
            this.setRoutingActionList(new ArrayList<RoutingAction>());
        }
        this.getRoutingActionList().add(item);
        item.setRouting(this);
    }

    public void removeRoutingActionListItem(RoutingAction item) {
        if (this.getRoutingActionList() == null) {
            return;
        }
        this.getRoutingActionList().remove((Object)item);
    }

    public void clearRoutingActionList() {
        if (this.getRoutingActionList() != null) {
            this.getRoutingActionList().clear();
        }
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Routing)) {
            return false;
        }
        Routing other = (Routing)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("code", (Object)this.getCode()).add("priority", (Object)this.getPriority()).add("isActive", (Object)this.getIsActive()).omitNullValues().toString();
    }
}

