/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.Sequence;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.time.LocalDate;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BASE_SEQUENCE_VERSION", uniqueConstraints={@UniqueConstraint(columnNames={"sequence", "startDate", "endDate"})}, indexes={@Index(columnList="sequence"), @Index(name="idx_sequence_version_sequence_start_date", columnList="sequence,startDate"), @Index(name="idx_sequence_version_sequence_start_date_end_date", columnList="sequence,startDate,endDate")})
public class SequenceVersion
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_SEQUENCE_VERSION_SEQ")
    @SequenceGenerator(name="BASE_SEQUENCE_VERSION_SEQ", sequenceName="BASE_SEQUENCE_VERSION_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Sequence")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Sequence sequence;
    @NotNull
    private LocalDate startDate;
    private LocalDate endDate;
    @Widget(title="Next N\u00b0")
    @NotNull
    @Min(value=1L)
    private Long nextNum = 1L;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public SequenceVersion() {
    }

    public SequenceVersion(Sequence sequence, LocalDate startDate, LocalDate endDate, Long nextNum) {
        this.sequence = sequence;
        this.startDate = startDate;
        this.endDate = endDate;
        this.nextNum = nextNum;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public void setSequence(Sequence sequence) {
        this.sequence = sequence;
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public Long getNextNum() {
        return this.nextNum == null ? 0L : this.nextNum;
    }

    public void setNextNum(Long nextNum) {
        this.nextNum = nextNum;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SequenceVersion)) {
            return false;
        }
        SequenceVersion other = (SequenceVersion)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("startDate", (Object)this.getStartDate()).add("endDate", (Object)this.getEndDate()).add("nextNum", (Object)this.getNextNum()).omitNullValues().toString();
    }
}

