/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.ICalendar;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BASE_SHARING_SETTING", indexes={@Index(columnList="shared_with"), @Index(columnList="calendar")})
public class SharingSetting
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_SHARING_SETTING_SEQ")
    @SequenceGenerator(name="BASE_SHARING_SETTING_SEQ", sequenceName="BASE_SHARING_SETTING_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Shared with")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User sharedWith;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ICalendar calendar;
    @Widget(title="Visible")
    private Boolean visible = Boolean.FALSE;
    @Widget(title="Rights", selection="base.sharing.setting.rights.select")
    private Integer rightsSelect = 1;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public User getSharedWith() {
        return this.sharedWith;
    }

    public void setSharedWith(User sharedWith) {
        this.sharedWith = sharedWith;
    }

    public ICalendar getCalendar() {
        return this.calendar;
    }

    public void setCalendar(ICalendar calendar) {
        this.calendar = calendar;
    }

    public Boolean getVisible() {
        return this.visible == null ? Boolean.FALSE : this.visible;
    }

    public void setVisible(Boolean visible) {
        this.visible = visible;
    }

    public Integer getRightsSelect() {
        return this.rightsSelect == null ? 0 : this.rightsSelect;
    }

    public void setRightsSelect(Integer rightsSelect) {
        this.rightsSelect = rightsSelect;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SharingSetting)) {
            return false;
        }
        SharingSetting other = (SharingSetting)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("visible", (Object)this.getVisible()).add("rightsSelect", (Object)this.getRightsSelect()).omitNullValues().toString();
    }
}

