/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.TemplateRuleLine;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaModel;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BASE_TEMPLATE_RULE", indexes={@Index(columnList="name"), @Index(columnList="meta_model")})
public class TemplateRule
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_TEMPLATE_RULE_SEQ")
    @SequenceGenerator(name="BASE_TEMPLATE_RULE_SEQ", sequenceName="BASE_TEMPLATE_RULE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Name")
    @NameColumn
    private String name;
    @Widget(title="Model")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaModel metaModel;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="templateRule", cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderBy(value="sequence")
    private List<TemplateRuleLine> templateRuleLineList;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public TemplateRule() {
    }

    public TemplateRule(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MetaModel getMetaModel() {
        return this.metaModel;
    }

    public void setMetaModel(MetaModel metaModel) {
        this.metaModel = metaModel;
    }

    public List<TemplateRuleLine> getTemplateRuleLineList() {
        return this.templateRuleLineList;
    }

    public void setTemplateRuleLineList(List<TemplateRuleLine> templateRuleLineList) {
        this.templateRuleLineList = templateRuleLineList;
    }

    public void addTemplateRuleLineListItem(TemplateRuleLine item) {
        if (this.getTemplateRuleLineList() == null) {
            this.setTemplateRuleLineList(new ArrayList<TemplateRuleLine>());
        }
        this.getTemplateRuleLineList().add(item);
        item.setTemplateRule(this);
    }

    public void removeTemplateRuleLineListItem(TemplateRuleLine item) {
        if (this.getTemplateRuleLineList() == null) {
            return;
        }
        this.getTemplateRuleLineList().remove((Object)item);
    }

    public void clearTemplateRuleLineList() {
        if (this.getTemplateRuleLineList() != null) {
            this.getTemplateRuleLineList().clear();
        }
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TemplateRule)) {
            return false;
        }
        TemplateRule other = (TemplateRule)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).omitNullValues().toString();
    }
}

