/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.TimerHistory;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BASE_TIMER", indexes={@Index(columnList="assigned_to_user")})
public class Timer
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_TIMER_SEQ")
    @SequenceGenerator(name="BASE_TIMER_SEQ", sequenceName="BASE_TIMER_SEQ", allocationSize=1)
    private Long id;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="timer", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<TimerHistory> timerHistoryList;
    @Widget(readonly=true)
    private Integer statusSelect = 0;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User assignedToUser;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public List<TimerHistory> getTimerHistoryList() {
        return this.timerHistoryList;
    }

    public void setTimerHistoryList(List<TimerHistory> timerHistoryList) {
        this.timerHistoryList = timerHistoryList;
    }

    public void addTimerHistoryListItem(TimerHistory item) {
        if (this.getTimerHistoryList() == null) {
            this.setTimerHistoryList(new ArrayList<TimerHistory>());
        }
        this.getTimerHistoryList().add(item);
        item.setTimer(this);
    }

    public void removeTimerHistoryListItem(TimerHistory item) {
        if (this.getTimerHistoryList() == null) {
            return;
        }
        this.getTimerHistoryList().remove((Object)item);
    }

    public void clearTimerHistoryList() {
        if (this.getTimerHistoryList() != null) {
            this.getTimerHistoryList().clear();
        }
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public User getAssignedToUser() {
        return this.assignedToUser;
    }

    public void setAssignedToUser(User assignedToUser) {
        this.assignedToUser = assignedToUser;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Timer)) {
            return false;
        }
        Timer other = (Timer)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("statusSelect", (Object)this.getStatusSelect()).omitNullValues().toString();
    }
}

