/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="BASE_UNIT", indexes={@Index(columnList="name")})
public class Unit
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_UNIT_SEQ")
    @SequenceGenerator(name="BASE_UNIT_SEQ", sequenceName="BASE_UNIT_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Unit", translatable=true)
    @NameColumn
    @NotNull
    private String name;
    @Widget(title="Label To Printing", translatable=true)
    private String labelToPrinting;
    @Widget(title="Unit type", selection="unit.unit.type.select")
    private Integer unitTypeSelect = 0;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Unit() {
    }

    public Unit(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLabelToPrinting() {
        return this.labelToPrinting;
    }

    public void setLabelToPrinting(String labelToPrinting) {
        this.labelToPrinting = labelToPrinting;
    }

    public Integer getUnitTypeSelect() {
        return this.unitTypeSelect == null ? 0 : this.unitTypeSelect;
    }

    public void setUnitTypeSelect(Integer unitTypeSelect) {
        this.unitTypeSelect = unitTypeSelect;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Unit)) {
            return false;
        }
        Unit other = (Unit)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("labelToPrinting", (Object)this.getLabelToPrinting()).add("unitTypeSelect", (Object)this.getUnitTypeSelect()).omitNullValues().toString();
    }
}

