/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.Unit;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.VirtualColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.Objects;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Cacheable
@DynamicInsert
@DynamicUpdate
@Table(name="BASE_UNIT_CONVERSION", indexes={@Index(columnList="start_unit"), @Index(columnList="end_unit"), @Index(columnList="name")})
public class UnitConversion
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_UNIT_CONVERSION_SEQ")
    @SequenceGenerator(name="BASE_UNIT_CONVERSION_SEQ", sequenceName="BASE_UNIT_CONVERSION_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="From Unit")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Unit startUnit;
    @Widget(title="To Unit")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Unit endUnit;
    @Widget(title="Coeff.")
    @NotNull
    @Digits(integer=18, fraction=12)
    private BigDecimal coef = BigDecimal.ZERO;
    @Widget(title="Type", selection="unit.conversion.type.select")
    private Integer typeSelect = 1;
    @Widget(title="Formula")
    private String formula;
    @Widget(title="Name", search={"startUnit", "endUnit"})
    @VirtualColumn
    @Access(value=AccessType.PROPERTY)
    private String name;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public UnitConversion() {
    }

    public UnitConversion(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Unit getStartUnit() {
        return this.startUnit;
    }

    public void setStartUnit(Unit startUnit) {
        this.startUnit = startUnit;
    }

    public Unit getEndUnit() {
        return this.endUnit;
    }

    public void setEndUnit(Unit endUnit) {
        this.endUnit = endUnit;
    }

    public BigDecimal getCoef() {
        return this.coef == null ? BigDecimal.ZERO : this.coef;
    }

    public void setCoef(BigDecimal coef) {
        this.coef = coef;
    }

    public Integer getTypeSelect() {
        return this.typeSelect == null ? 0 : this.typeSelect;
    }

    public void setTypeSelect(Integer typeSelect) {
        this.typeSelect = typeSelect;
    }

    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    public String getName() {
        try {
            this.name = this.computeName();
        }
        catch (NullPointerException e) {
            Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
            logger.error("NPE in function field: getName()", (Throwable)e);
        }
        return this.name;
    }

    protected String computeName() {
        return this.startUnit.getName() + " => " + this.endUnit.getName();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof UnitConversion)) {
            return false;
        }
        UnitConversion other = (UnitConversion)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("coef", (Object)this.getCoef()).add("typeSelect", (Object)this.getTypeSelect()).add("formula", (Object)this.getFormula()).omitNullValues().toString();
    }
}

