/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.DayPlanning;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="BASE_WEEKLY_PLANNING", indexes={@Index(columnList="name")})
public class WeeklyPlanning
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_WEEKLY_PLANNING_SEQ")
    @SequenceGenerator(name="BASE_WEEKLY_PLANNING_SEQ", sequenceName="BASE_WEEKLY_PLANNING_SEQ", allocationSize=1)
    private Long id;
    @NameColumn
    @NotNull
    private String name;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="weeklyPlann", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<DayPlanning> weekDays;
    @Widget(title="Coefficient for bonus")
    private BigDecimal bonusCoef = BigDecimal.ZERO;
    @Widget(title="Coefficient for leave")
    private BigDecimal leaveCoef = BigDecimal.ZERO;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public WeeklyPlanning() {
    }

    public WeeklyPlanning(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<DayPlanning> getWeekDays() {
        return this.weekDays;
    }

    public void setWeekDays(List<DayPlanning> weekDays) {
        this.weekDays = weekDays;
    }

    public void addWeekDay(DayPlanning item) {
        if (this.getWeekDays() == null) {
            this.setWeekDays(new ArrayList<DayPlanning>());
        }
        this.getWeekDays().add(item);
        item.setWeeklyPlann(this);
    }

    public void removeWeekDay(DayPlanning item) {
        if (this.getWeekDays() == null) {
            return;
        }
        this.getWeekDays().remove((Object)item);
    }

    public void clearWeekDays() {
        if (this.getWeekDays() != null) {
            this.getWeekDays().clear();
        }
    }

    public BigDecimal getBonusCoef() {
        return this.bonusCoef == null ? BigDecimal.ZERO : this.bonusCoef;
    }

    public void setBonusCoef(BigDecimal bonusCoef) {
        this.bonusCoef = bonusCoef;
    }

    public BigDecimal getLeaveCoef() {
        return this.leaveCoef == null ? BigDecimal.ZERO : this.leaveCoef;
    }

    public void setLeaveCoef(BigDecimal leaveCoef) {
        this.leaveCoef = leaveCoef;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof WeeklyPlanning)) {
            return false;
        }
        WeeklyPlanning other = (WeeklyPlanning)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("bonusCoef", (Object)this.getBonusCoef()).add("leaveCoef", (Object)this.getLeaveCoef()).omitNullValues().toString();
    }
}

