/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db.repo;

import com.axelor.apps.base.db.ICalendarEvent;
import com.axelor.apps.base.db.ICalendarUser;
import com.axelor.apps.base.db.repo.ICalendarEventRepository;
import com.axelor.apps.base.db.repo.ICalendarUserRepository;
import com.axelor.apps.base.ical.ICalendarService;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.db.Model;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;

public class ICalendarEventManagementRepository
extends ICalendarEventRepository {
    @Inject
    private ICalendarService calendarService;

    public ICalendarEvent save(ICalendarEvent entity) {
        String email;
        User creator = entity.getCreatedBy();
        if (creator == null) {
            creator = AuthUtils.getUser();
        }
        if (entity.getOrganizer() == null && creator != null && creator.getPartner() != null && creator.getPartner().getEmailAddress() != null && (email = creator.getPartner().getEmailAddress().getAddress()) != null) {
            ICalendarUser organizer = (ICalendarUser)((Object)((ICalendarUserRepository)((Object)Beans.get(ICalendarUserRepository.class))).all().filter("self.email = ?1 AND self.user.id = ?2", new Object[]{email, creator.getId()}).fetchOne());
            if (organizer == null) {
                organizer = new ICalendarUser();
                organizer.setEmail(email);
                organizer.setName(creator.getFullName());
                organizer.setUser(creator);
            }
            entity.setOrganizer(organizer);
        }
        entity.setSubjectTeam(entity.getSubject());
        if (entity.getVisibilitySelect() == ICalendarEventRepository.VISIBILITY_PRIVATE) {
            entity.setSubjectTeam(I18n.get((String)"Available"));
            if (entity.getDisponibilitySelect() == ICalendarEventRepository.DISPONIBILITY_BUSY) {
                entity.setSubjectTeam(I18n.get((String)"Busy"));
            }
        }
        return (ICalendarEvent)((Object)super.save((Model)((Object)entity)));
    }

    public void remove(ICalendarEvent entity) {
        this.remove(entity, true);
    }

    public void remove(ICalendarEvent entity, boolean removeRemote) {
        try {
            if (removeRemote) {
                this.calendarService.removeEventFromIcal(entity);
            }
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)e);
        }
        super.remove((Model)((Object)entity));
    }
}

