/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db.repo;

import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.PartnerAddress;
import com.axelor.apps.base.db.repo.PartnerAddressRepository;
import com.axelor.apps.base.db.repo.PartnerRepository;
import com.axelor.apps.base.db.repo.UserBaseRepository;
import com.axelor.apps.base.service.PartnerService;
import com.axelor.auth.db.User;
import com.axelor.db.Model;
import com.axelor.inject.Beans;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import javax.persistence.PersistenceException;

public class PartnerBaseRepository
extends PartnerRepository {
    public Partner save(Partner partner) {
        try {
            ((PartnerService)Beans.get(PartnerService.class)).onSave(partner);
            return (Partner)((Object)super.save((Model)((Object)partner)));
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public Map<String, Object> populate(Map<String, Object> json, Map<String, Object> context) {
        if (!context.containsKey("json-enhance")) {
            return json;
        }
        try {
            Long id = (Long)json.get("id");
            Partner partner = (Partner)((Object)this.find(id));
            json.put("address", (Object)((PartnerService)Beans.get(PartnerService.class)).getDefaultAddress(partner));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return json;
    }

    public Partner copy(Partner partner, boolean deep) {
        Partner copy = (Partner)((Object)super.copy((Model)((Object)partner), deep));
        copy.setPartnerSeq(null);
        copy.setEmailAddress(null);
        PartnerAddressRepository partnerAddressRepository = (PartnerAddressRepository)((Object)Beans.get(PartnerAddressRepository.class));
        ArrayList partnerAddressList = Lists.newArrayList();
        if (deep && copy.getPartnerAddressList() != null) {
            for (PartnerAddress partnerAddress : copy.getPartnerAddressList()) {
                partnerAddressList.add(partnerAddressRepository.copy((Model)((Object)partnerAddress), deep));
            }
        }
        copy.setPartnerAddressList(partnerAddressList);
        copy.setBlockingList(null);
        copy.setBankDetailsList(null);
        return copy;
    }

    public void remove(Partner partner) {
        UserBaseRepository userRepo;
        User user;
        if (partner.getLinkedUser() != null && (user = (User)((Object)(userRepo = (UserBaseRepository)((Object)Beans.get(UserBaseRepository.class))).find(partner.getLinkedUser().getId()))) != null) {
            user.setPartner(null);
            userRepo.save(user);
        }
        super.remove((Model)((Object)partner));
    }
}

