/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.ical;

import com.axelor.apps.base.db.ICalendar;
import com.axelor.apps.base.db.ICalendarEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public class ICalendarEventFactory {
    private static final Map<String, Supplier<ICalendarEvent>> map = new HashMap<String, Supplier<ICalendarEvent>>();

    public static ICalendarEvent getNewIcalEvent(ICalendar calendar) {
        Supplier<ICalendarEvent> supplier = map.getOrDefault(calendar.getSynchronizationSelect(), ICalendarEvent::new);
        return supplier.get();
    }

    public static void register(String selection, Supplier<ICalendarEvent> eventSupplier) {
        map.put(selection, eventSupplier);
    }

    static {
        map.put("ICalEvent", ICalendarEvent::new);
    }
}

