/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.ical;

import com.axelor.apps.base.db.ICalendar;
import com.axelor.apps.base.db.ICalendarEvent;
import com.axelor.apps.base.db.ICalendarUser;
import com.axelor.apps.base.db.repo.ICalendarEventRepository;
import com.axelor.apps.base.db.repo.ICalendarRepository;
import com.axelor.apps.base.db.repo.ICalendarUserRepository;
import com.axelor.apps.base.ical.ICalendarEventFactory;
import com.axelor.apps.base.ical.ICalendarException;
import com.axelor.apps.base.ical.ICalendarStore;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.message.db.EmailAddress;
import com.axelor.apps.message.db.repo.EmailAddressRepository;
import com.axelor.apps.message.service.MailAccountService;
import com.axelor.apps.tool.QueryBuilder;
import com.axelor.auth.db.User;
import com.axelor.common.StringUtils;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.SecureRandom;
import java.text.ParseException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import net.fortuna.ical4j.connector.FailedOperationException;
import net.fortuna.ical4j.connector.ObjectStoreException;
import net.fortuna.ical4j.connector.dav.CalDavCalendarCollection;
import net.fortuna.ical4j.connector.dav.PathResolver;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.data.CalendarOutputter;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ConstraintViolationException;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.parameter.Cn;
import net.fortuna.ical4j.model.property.Attendee;
import net.fortuna.ical4j.model.property.CalScale;
import net.fortuna.ical4j.model.property.Clazz;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.DtEnd;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.Geo;
import net.fortuna.ical4j.model.property.LastModified;
import net.fortuna.ical4j.model.property.Location;
import net.fortuna.ical4j.model.property.Organizer;
import net.fortuna.ical4j.model.property.ProdId;
import net.fortuna.ical4j.model.property.Status;
import net.fortuna.ical4j.model.property.Summary;
import net.fortuna.ical4j.model.property.Transp;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.model.property.Url;
import net.fortuna.ical4j.model.property.Version;
import net.fortuna.ical4j.model.property.XProperty;
import net.fortuna.ical4j.util.FixedUidGenerator;
import net.fortuna.ical4j.util.HostInfo;
import net.fortuna.ical4j.util.InetAddressHostInfo;
import net.fortuna.ical4j.util.SimpleHostInfo;
import net.fortuna.ical4j.util.UidGenerator;
import net.fortuna.ical4j.util.Uris;
import net.fortuna.ical4j.validate.ValidationException;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.client.methods.DeleteMethod;

public class ICalendarService {
    static final String PRODUCT_ID = "-//Axelor//ADK Calendar 1.0//EN";
    static final String X_WR_CALNAME = "X-WR-CALNAME";
    protected static UidGenerator generator;
    @Inject
    protected ICalendarUserRepository iCalendarUserRepository;
    @Inject
    protected ICalendarEventRepository iEventRepo;
    @Inject
    private MailAccountService mailAccountService;

    public static Uid nextUid() throws SocketException {
        if (generator == null) {
            SimpleHostInfo info = new SimpleHostInfo("localhost");
            try {
                info = new InetAddressHostInfo(InetAddress.getLocalHost());
            }
            catch (Exception exception) {
                // empty catch block
            }
            generator = new FixedUidGenerator((HostInfo)info, "" + new SecureRandom().nextInt(Integer.MAX_VALUE));
        }
        return generator.generateUid();
    }

    public static Calendar newCalendar() {
        Calendar cal = new Calendar();
        cal.getProperties().add((Property)new ProdId(PRODUCT_ID));
        cal.getProperties().add((Property)Version.VERSION_2_0);
        cal.getProperties().add((Property)CalScale.GREGORIAN);
        return cal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConnect(ICalendar cal) throws MalformedURLException, ObjectStoreException {
        PathResolver RESOLVER = this.getPathResolver(cal.getTypeSelect());
        Protocol protocol = this.getProtocol(cal.getIsSslConnection());
        URL url = new URL(protocol.getScheme(), cal.getUrl(), cal.getPort(), "");
        ICalendarStore store = new ICalendarStore(url, RESOLVER);
        try {
            store.connect(cal.getLogin(), this.getCalendarDecryptPassword(cal.getPassword()));
        }
        finally {
            store.disconnect();
        }
    }

    public Protocol getProtocol(boolean isSslConnection) {
        if (isSslConnection) {
            return Protocol.getProtocol((String)"https");
        }
        return Protocol.getProtocol((String)"http");
    }

    @Transactional(rollbackOn={Exception.class})
    public void load(ICalendar calendar, String text) throws ParserException {
        Preconditions.checkNotNull((Object)((Object)calendar), (Object)"calendar can't be null");
        Preconditions.checkNotNull((Object)text, (Object)"calendar source can't be null");
        StringReader reader = new StringReader(text);
        try {
            this.load(calendar, reader);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackOn={Exception.class})
    public void load(ICalendar calendar, File file) throws IOException, ParserException {
        Preconditions.checkNotNull((Object)((Object)calendar), (Object)"calendar can't be null");
        Preconditions.checkNotNull((Object)file, (Object)"input file can't be null");
        Preconditions.checkArgument((boolean)file.exists(), (Object)("no such file: " + file));
        try (FileReader reader = new FileReader(file);){
            this.load(calendar, reader);
        }
    }

    @Transactional(rollbackOn={Exception.class})
    public void load(ICalendar calendar, Reader reader) throws IOException, ParserException {
        Preconditions.checkNotNull((Object)((Object)calendar), (Object)"calendar can't be null");
        Preconditions.checkNotNull((Object)reader, (Object)"reader can't be null");
        CalendarBuilder builder = new CalendarBuilder();
        Calendar cal = builder.build(reader);
        if (calendar.getName() == null && cal.getProperty(X_WR_CALNAME) != null) {
            calendar.setName(cal.getProperty(X_WR_CALNAME).getValue());
        }
        for (Object item : cal.getComponents("VEVENT")) {
            this.findOrCreateEvent((VEvent)item, calendar);
        }
    }

    protected String getValue(Component component, String name) {
        if (component.getProperty(name) != null) {
            return component.getProperty(name).getValue();
        }
        return null;
    }

    @Transactional
    protected ICalendarEvent findOrCreateEvent(VEvent vEvent, ICalendar calendar) {
        ICalendarUser organizer;
        String uid = vEvent.getUid().getValue();
        DtStart dtStart = vEvent.getStartDate();
        DtEnd dtEnd = vEvent.getEndDate();
        ICalendarEvent event = this.iEventRepo.findByUid(uid);
        if (event == null) {
            event = ICalendarEventFactory.getNewIcalEvent(calendar);
            event.setUid(uid);
            event.setCalendar(calendar);
        }
        ZoneId zoneId = OffsetDateTime.now().getOffset();
        if (dtStart.getDate() != null) {
            if (dtStart.getTimeZone() != null) {
                zoneId = dtStart.getTimeZone().toZoneId();
            }
            event.setStartDateTime(LocalDateTime.ofInstant(dtStart.getDate().toInstant(), zoneId));
        }
        if (dtEnd.getDate() != null) {
            if (dtEnd.getTimeZone() != null) {
                zoneId = dtEnd.getTimeZone().toZoneId();
            }
            event.setEndDateTime(LocalDateTime.ofInstant(dtEnd.getDate().toInstant(), zoneId));
        }
        event.setAllDay(!(dtStart.getDate() instanceof DateTime));
        event.setSubject(this.getValue((Component)vEvent, "SUMMARY"));
        event.setDescription(this.getValue((Component)vEvent, "DESCRIPTION"));
        event.setLocation(this.getValue((Component)vEvent, "LOCATION"));
        event.setGeo(this.getValue((Component)vEvent, "GEO"));
        event.setUrl(this.getValue((Component)vEvent, "URL"));
        event.setSubjectTeam(event.getSubject());
        if (Clazz.PRIVATE.getValue().equals(this.getValue((Component)vEvent, "CLASS"))) {
            event.setVisibilitySelect(ICalendarEventRepository.VISIBILITY_PRIVATE);
        } else {
            event.setVisibilitySelect(ICalendarEventRepository.VISIBILITY_PUBLIC);
        }
        if (Transp.TRANSPARENT.getValue().equals(this.getValue((Component)vEvent, "TRANSP"))) {
            event.setDisponibilitySelect(ICalendarEventRepository.DISPONIBILITY_AVAILABLE);
        } else {
            event.setDisponibilitySelect(ICalendarEventRepository.DISPONIBILITY_BUSY);
        }
        if (event.getVisibilitySelect() == ICalendarEventRepository.VISIBILITY_PRIVATE) {
            event.setSubjectTeam(I18n.get((String)"Available"));
            if (event.getDisponibilitySelect() == ICalendarEventRepository.DISPONIBILITY_BUSY) {
                event.setSubjectTeam(I18n.get((String)"Busy"));
            }
        }
        if ((organizer = this.findOrCreateUser((Property)vEvent.getOrganizer(), event)) != null) {
            event.setOrganizer(organizer);
            this.iCalendarUserRepository.save((Model)((Object)organizer));
        }
        for (Object item : vEvent.getProperties("ATTENDEE")) {
            ICalendarUser attendee = this.findOrCreateUser((Property)item, event);
            if (attendee == null) continue;
            event.addAttendee(attendee);
            this.iCalendarUserRepository.save((Model)((Object)attendee));
        }
        this.iEventRepo.save((Model)((Object)event));
        return event;
    }

    public ICalendarUser findOrCreateUser(User user) {
        String email = null;
        if (user.getPartner() != null && user.getPartner().getEmailAddress() != null && !Strings.isNullOrEmpty((String)user.getPartner().getEmailAddress().getAddress())) {
            email = user.getPartner().getEmailAddress().getAddress();
        } else if (!Strings.isNullOrEmpty((String)user.getEmail())) {
            email = user.getEmail();
        } else {
            return null;
        }
        ICalendarUserRepository repo = (ICalendarUserRepository)((Object)Beans.get(ICalendarUserRepository.class));
        ICalendarUser icalUser = null;
        icalUser = (ICalendarUser)((Object)repo.all().filter("self.email = ?1 AND self.user.id = ?2", new Object[]{email, user.getId()}).fetchOne());
        if (icalUser == null) {
            icalUser = (ICalendarUser)((Object)repo.all().filter("self.user.id = ?1", new Object[]{user.getId()}).fetchOne());
        }
        if (icalUser == null) {
            icalUser = (ICalendarUser)((Object)repo.all().filter("self.email = ?1", new Object[]{email}).fetchOne());
        }
        if (icalUser == null) {
            icalUser = new ICalendarUser();
            icalUser.setEmail(email);
            icalUser.setName(user.getFullName());
            EmailAddress emailAddress = ((EmailAddressRepository)((Object)Beans.get(EmailAddressRepository.class))).findByAddress(email);
            if (emailAddress != null && emailAddress.getPartner() != null && emailAddress.getPartner().getUser() != null) {
                icalUser.setUser(emailAddress.getPartner().getUser());
            }
        }
        return icalUser;
    }

    protected ICalendarUser findOrCreateUser(Property source, ICalendarEvent event) {
        URI addr = null;
        if (source instanceof Organizer) {
            addr = ((Organizer)source).getCalAddress();
        }
        if (source instanceof Attendee) {
            addr = ((Attendee)source).getCalAddress();
        }
        if (addr == null) {
            return null;
        }
        String email = this.mailto(addr.toString(), true);
        ICalendarUserRepository repo = (ICalendarUserRepository)((Object)Beans.get(ICalendarUserRepository.class));
        ICalendarUser user = null;
        user = source instanceof Organizer ? (ICalendarUser)((Object)repo.all().filter("self.email = ?1", new Object[]{email}).fetchOne()) : (ICalendarUser)((Object)repo.all().filter("self.email = ?1 AND self.event.id = ?2", new Object[]{email, event.getId()}).fetchOne());
        if (user == null) {
            user = new ICalendarUser();
            user.setEmail(email);
            user.setName(email);
            EmailAddress emailAddress = ((EmailAddressRepository)((Object)Beans.get(EmailAddressRepository.class))).findByAddress(email);
            if (emailAddress != null && emailAddress.getPartner() != null && emailAddress.getPartner().getUser() != null) {
                user.setUser(emailAddress.getPartner().getUser());
            }
        }
        if (source.getParameter("CN") != null) {
            user.setName(source.getParameter("CN").getValue());
        }
        if (source.getParameter("PARTSTAT") != null) {
            String role = source.getParameter("PARTSTAT").getValue();
            if (role.equals("TENTATIVE")) {
                user.setStatusSelect(ICalendarUserRepository.STATUS_MAYBE);
            } else if (role.equals("ACCEPTED")) {
                user.setStatusSelect(ICalendarUserRepository.STATUS_YES);
            } else if (role.equals("DECLINED")) {
                user.setStatusSelect(ICalendarUserRepository.STATUS_NO);
            }
        }
        return user;
    }

    public <T extends Property> T updateUser(T target, ICalendarUser user) {
        if (user == null || user.getEmail() == null) {
            return null;
        }
        String email = this.mailto(user.getEmail(), false);
        String name = user.getName();
        if (target instanceof Organizer) {
            ((Organizer)target).setCalAddress(this.createUri(email));
        }
        if (target instanceof Attendee) {
            ((Attendee)target).setCalAddress(this.createUri(email));
        }
        if (name != null) {
            target.getParameters().add((Parameter)new Cn(name));
        }
        return target;
    }

    protected String mailto(String mail, boolean strip) {
        if (mail == null) {
            return null;
        }
        String res = mail.trim();
        if (strip) {
            if (res.toLowerCase().startsWith("mailto:")) {
                res = res.substring(7);
            }
        } else if (!res.toLowerCase().startsWith("mailto:")) {
            res = "mailto:" + res;
        }
        return res;
    }

    protected net.fortuna.ical4j.model.Date toDate(LocalDateTime dt, boolean allDay) {
        if (dt == null) {
            return null;
        }
        if (allDay) {
            return new net.fortuna.ical4j.model.Date(Date.from(dt.toInstant(OffsetDateTime.now().getOffset())));
        }
        return new DateTime(Date.from(dt.toInstant(OffsetDateTime.now().getOffset())));
    }

    protected URI createUri(String uri) {
        try {
            return Uris.create((String)uri);
        }
        catch (URISyntaxException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    protected VEvent createVEvent(ICalendarEvent event) throws SocketException, ParseException {
        LastModified lastModified;
        DateTime date;
        boolean allDay = event.getAllDay() == Boolean.TRUE;
        net.fortuna.ical4j.model.Date start = this.toDate(event.getStartDateTime(), allDay);
        net.fortuna.ical4j.model.Date end = this.toDate(event.getEndDateTime(), allDay);
        VEvent vevent = new VEvent();
        PropertyList items = vevent.getProperties();
        items.add((Property)new DtStart(start));
        if (end != null) {
            items.add((Property)new DtEnd(end));
        }
        if (event.getSubject() != null) {
            items.add((Property)new Summary(event.getSubject()));
        }
        if (event.getDescription() != null) {
            items.add((Property)new Description(event.getDescription()));
        }
        if (event.getStatus() != null) {
            items.add((Property)new Status(event.getStatus()));
        }
        if (event.getLocation() != null) {
            items.add((Property)new Location(event.getLocation()));
        }
        if (event.getGeo() != null) {
            items.add((Property)new Geo(event.getGeo()));
        }
        if (event.getUid() == null) {
            items.add((Property)ICalendarService.nextUid());
        } else {
            items.add((Property)new Uid(event.getUid()));
        }
        if (event.getUrl() != null) {
            items.add((Property)new Url(this.createUri(event.getUrl())));
        }
        if (event.getUpdatedOn() != null) {
            date = new DateTime(Date.from(event.getUpdatedOn().toInstant(OffsetDateTime.now().getOffset())));
            date.setUtc(true);
            lastModified = new LastModified(date);
            items.add((Property)lastModified);
        } else {
            date = new DateTime(Date.from(event.getCreatedOn().toInstant(OffsetDateTime.now().getOffset())));
            date.setUtc(true);
            lastModified = new LastModified(date);
            items.add((Property)lastModified);
        }
        Organizer organizer = this.updateUser(new Organizer(), event.getOrganizer());
        if (organizer != null) {
            items.add((Property)organizer);
        }
        if (event.getAttendees() != null) {
            for (ICalendarUser user : event.getAttendees()) {
                Attendee attendee = this.updateUser(new Attendee(), user);
                if (attendee == null) continue;
                items.add((Property)attendee);
            }
        }
        return vevent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(ICalendar calendar, File file) throws IOException, ParseException, ValidationException {
        Preconditions.checkNotNull((Object)((Object)calendar), (Object)"calendar can't be null");
        Preconditions.checkNotNull((Object)file, (Object)"input file can't be null");
        try (FileWriter writer = new FileWriter(file);){
            this.export(calendar, writer);
        }
    }

    public void export(ICalendar calendar, Writer writer) throws IOException, ParseException, ValidationException {
        Preconditions.checkNotNull((Object)((Object)calendar), (Object)"calendar can't be null");
        Preconditions.checkNotNull((Object)writer, (Object)"writer can't be null");
        Preconditions.checkNotNull(this.getICalendarEvents(calendar), (Object)"can't export empty calendar");
        Calendar cal = ICalendarService.newCalendar();
        cal.getProperties().add((Property)new XProperty(X_WR_CALNAME, calendar.getName()));
        for (ICalendarEvent item : this.getICalendarEvents(calendar)) {
            VEvent event = this.createVEvent(item);
            cal.getComponents().add((Object)event);
        }
        CalendarOutputter outputter = new CalendarOutputter();
        outputter.output(cal, writer);
    }

    public void sync(ICalendar calendar, boolean all, int weeks) throws MalformedURLException, ICalendarException {
        if (all || calendar.getLastSynchronizationDateT() == null) {
            this.sync(calendar, null, null);
        } else {
            int nbOfWeeks = weeks <= 0 ? calendar.getSynchronizationDuration() : weeks;
            LocalDateTime now = ((AppBaseService)Beans.get(AppBaseService.class)).getTodayDateTime().toLocalDateTime();
            this.sync(calendar, now.minusWeeks(nbOfWeeks), now.plusWeeks(nbOfWeeks));
        }
    }

    @Transactional(rollbackOn={Exception.class})
    protected void sync(ICalendar calendar, LocalDateTime startDate, LocalDateTime endDate) throws ICalendarException, MalformedURLException {
        block7: {
            PathResolver RESOLVER = this.getPathResolver(calendar.getTypeSelect());
            Protocol protocol = this.getProtocol(calendar.getIsSslConnection());
            URL url = new URL(protocol.getScheme(), calendar.getUrl(), calendar.getPort(), "");
            ICalendarStore store = new ICalendarStore(url, RESOLVER);
            try {
                String password = this.getCalendarDecryptPassword(calendar.getPassword());
                if (calendar.getLogin() != null && calendar.getPassword() != null && store.connect(calendar.getLogin(), password)) {
                    List<CalDavCalendarCollection> colList = store.getCollections();
                    if (!colList.isEmpty()) {
                        calendar = this.doSync(calendar, colList.get(0), startDate, endDate);
                        calendar.setLastSynchronizationDateT(((AppBaseService)Beans.get(AppBaseService.class)).getTodayDateTime().toLocalDateTime());
                        ((ICalendarRepository)((Object)Beans.get(ICalendarRepository.class))).save((Model)((Object)calendar));
                    }
                    break block7;
                }
                throw new AxelorException(4, I18n.get((String)"Calendar configuration not valid"));
            }
            catch (Exception e) {
                throw new ICalendarException(e);
            }
            finally {
                store.disconnect();
            }
        }
    }

    @Transactional(rollbackOn={Exception.class})
    protected ICalendar doSync(ICalendar calendar, CalDavCalendarCollection collection, LocalDateTime startDate, LocalDateTime endDate) throws IOException, URISyntaxException, ParseException, ObjectStoreException, ConstraintViolationException, DavException, ParserConfigurationException, ParserException, AxelorException {
        boolean keepRemote = calendar.getKeepRemote() == Boolean.TRUE;
        HashMap<String, VEvent> modifiedRemoteEvents = new HashMap<String, VEvent>();
        List<ICalendarEvent> modifiedLocalEvents = this.getICalendarEvents(calendar);
        HashSet<String> allRemoteUids = new HashSet<String>();
        HashSet<VEvent> updatedEvents = new HashSet<VEvent>();
        List<VEvent> events = null;
        Instant lastSynchro = null;
        lastSynchro = calendar.getLastSynchronizationDateT() != null ? calendar.getLastSynchronizationDateT().toInstant(OffsetDateTime.now().getOffset()) : ((AppBaseService)Beans.get(AppBaseService.class)).getTodayDateTime().toLocalDateTime().toInstant(OffsetDateTime.now().getOffset());
        events = startDate == null || endDate == null ? ICalendarStore.getModifiedEvents(collection, null, allRemoteUids) : ICalendarStore.getModifiedEventsInRange(collection, lastSynchro, allRemoteUids, startDate, endDate);
        if (events == null || events.isEmpty()) {
            throw new AxelorException(4, I18n.get((String)"Calendars are empty, there is no event to synchronize."));
        }
        for (VEvent vEvent : events) {
            modifiedRemoteEvents.put(vEvent.getUid().getValue(), vEvent);
        }
        for (ICalendarEvent iCalendarEvent : modifiedLocalEvents) {
            VEvent source = this.createVEvent(iCalendarEvent);
            VEvent target = (VEvent)modifiedRemoteEvents.get(source.getUid().getValue());
            if (StringUtils.isBlank((CharSequence)iCalendarEvent.getUid())) {
                iCalendarEvent.setUid(source.getUid().getValue());
                Calendar cal = ICalendarService.newCalendar();
                cal.getComponents().add((Object)source);
                collection.addCalendar(cal);
                allRemoteUids.add(iCalendarEvent.getUid());
                continue;
            }
            if (target == null) {
                target = source;
            } else {
                this.updateEvent(source, target, keepRemote);
                modifiedRemoteEvents.remove(target.getUid().getValue());
            }
            updatedEvents.add(target);
        }
        for (Map.Entry entry : modifiedRemoteEvents.entrySet()) {
            this.findOrCreateEvent((VEvent)entry.getValue(), calendar);
        }
        for (VEvent vEvent : updatedEvents) {
            Calendar cal = ICalendarService.newCalendar();
            cal.getComponents().add((Object)vEvent);
            collection.updateCalendar(cal);
        }
        this.removeDeletedEventsInRange(allRemoteUids, calendar, startDate, endDate);
        return calendar;
    }

    @Transactional
    protected void removeDeletedEventsInRange(Set<String> allRemoteUids, ICalendar calendar, LocalDateTime startDate, LocalDateTime endDate) {
        QueryBuilder queryBuilder = QueryBuilder.of(ICalendarEvent.class);
        queryBuilder.add("self.uid NOT in (:uids)").bind("uids", allRemoteUids);
        queryBuilder.add("self.calendar = :calendar").bind("calendar", (Object)calendar);
        queryBuilder.add("self.archived = :archived OR self.archived IS NULL").bind("archived", (Object)false);
        if (startDate != null && endDate != null) {
            queryBuilder.add("self.startDateTime BETWEEN :start AND :end OR self.endDateTime BETWEEN :start AND :end").bind("start", (Object)startDate).bind("end", (Object)endDate);
        }
        ICalendarEventRepository repo = (ICalendarEventRepository)((Object)Beans.get(ICalendarEventRepository.class));
        for (ICalendarEvent event : queryBuilder.build().fetch()) {
            if ("ICalEvent".equals(calendar.getSynchronizationSelect())) {
                repo.remove((Model)((Object)event));
                continue;
            }
            event.setArchived(true);
        }
    }

    private VEvent updateEvent(VEvent source, VEvent target, boolean keepRemote) throws IOException, URISyntaxException, ParseException {
        String[] names = new String[]{"UID", "URL", "SUMMARY", "DESCRIPTION", "DTSTART", "DTEND", "ORGANIZER", "ATTENDEE"};
        if (keepRemote) {
            VEvent tmp = target;
            target = source;
            source = tmp;
        } else {
            if (source.getLastModified() != null && target.getLastModified() != null) {
                LocalDateTime lastModifiedTarget;
                LocalDateTime lastModifiedSource;
                ZoneId zoneId = OffsetDateTime.now().getOffset();
                if (source.getLastModified().getTimeZone() != null) {
                    zoneId = source.getLastModified().getTimeZone().toZoneId();
                }
                if ((lastModifiedSource = LocalDateTime.ofInstant(source.getLastModified().getDate().toInstant(), zoneId)).isBefore(lastModifiedTarget = LocalDateTime.ofInstant(target.getLastModified().getDate().toInstant(), zoneId))) {
                    VEvent tmp = target;
                    target = source;
                    source = tmp;
                }
            } else if (target.getLastModified() != null) {
                VEvent tmp = target;
                target = source;
                source = tmp;
            }
            if (source != target) {
                for (String name : names) {
                    Property s = source.getProperty(name);
                    Property t = target.getProperty(name);
                    if (s == null && t == null) continue;
                    if (t == null) {
                        t = s;
                    }
                    if (s == null) {
                        target.getProperties().remove(t);
                        continue;
                    }
                    t.setValue(s.getValue());
                }
            }
        }
        return target;
    }

    public PathResolver getPathResolver(int typeSelect) {
        switch (typeSelect) {
            case 1: {
                return PathResolver.ICAL_SERVER;
            }
            case 2: {
                return PathResolver.CALENDAR_SERVER;
            }
            case 3: {
                return PathResolver.GCAL;
            }
            case 4: {
                return PathResolver.ZIMBRA;
            }
            case 5: {
                return PathResolver.KMS;
            }
            case 6: {
                return PathResolver.CGP;
            }
            case 7: {
                return PathResolver.CHANDLER;
            }
        }
        return null;
    }

    public ICalendarEvent createEvent(LocalDateTime fromDateTime, LocalDateTime toDateTime, User user, String description, int type, String subject) {
        ICalendarEvent event = new ICalendarEvent();
        event.setSubject(subject);
        event.setStartDateTime(fromDateTime);
        event.setEndDateTime(toDateTime);
        event.setTypeSelect(type);
        event.setUser(user);
        event.setCalendar(user.getiCalendar());
        if (!Strings.isNullOrEmpty((String)description)) {
            event.setDescription(description);
        }
        return event;
    }

    public Calendar removeCalendar(CalDavCalendarCollection collection, String uid) throws FailedOperationException, ObjectStoreException {
        Calendar calendar = collection.getCalendar(uid);
        DeleteMethod deleteMethod = new DeleteMethod(collection.getPath() + uid + ".ics");
        try {
            collection.getStore().getClient().execute((HttpMethodBase)deleteMethod);
        }
        catch (IOException e) {
            throw new ObjectStoreException((Throwable)e);
        }
        if (!deleteMethod.succeeded()) {
            throw new FailedOperationException(deleteMethod.getStatusLine().toString());
        }
        return calendar;
    }

    public Calendar getCalendar(String uid, ICalendar calendar) throws ICalendarException, MalformedURLException {
        Calendar cal;
        block7: {
            cal = null;
            PathResolver RESOLVER = this.getPathResolver(calendar.getTypeSelect());
            Protocol protocol = this.getProtocol(calendar.getIsSslConnection());
            URL url = new URL(protocol.getScheme(), calendar.getUrl(), calendar.getPort(), "");
            ICalendarStore store = new ICalendarStore(url, RESOLVER);
            try {
                if (store.connect(calendar.getLogin(), calendar.getPassword())) {
                    List<CalDavCalendarCollection> colList = store.getCollections();
                    if (!colList.isEmpty()) {
                        CalDavCalendarCollection collection = colList.get(0);
                        cal = collection.getCalendar(uid);
                    }
                    break block7;
                }
                throw new AxelorException(4, I18n.get((String)"Calendar configuration not valid"));
            }
            catch (Exception e) {
                throw new ICalendarException(e);
            }
            finally {
                store.disconnect();
            }
        }
        return cal;
    }

    public void removeEventFromIcal(ICalendarEvent event) throws MalformedURLException, ICalendarException {
        block10: {
            if (event.getCalendar() != null && !Strings.isNullOrEmpty((String)event.getUid())) {
                ICalendar calendar = event.getCalendar();
                PathResolver RESOLVER = this.getPathResolver(calendar.getTypeSelect());
                Protocol protocol = this.getProtocol(calendar.getIsSslConnection());
                URL url = new URL(protocol.getScheme(), calendar.getUrl(), calendar.getPort(), "");
                ICalendarStore store = new ICalendarStore(url, RESOLVER);
                try {
                    if (store.connect(calendar.getLogin(), this.getCalendarDecryptPassword(calendar.getPassword()))) {
                        List<CalDavCalendarCollection> colList = store.getCollections();
                        if (!colList.isEmpty()) {
                            CalDavCalendarCollection collection = colList.get(0);
                            HashMap<String, VEvent> remoteEvents = new HashMap<String, VEvent>();
                            for (VEvent item : ICalendarStore.getEvents(collection)) {
                                remoteEvents.put(item.getUid().getValue(), item);
                            }
                            VEvent target = (VEvent)remoteEvents.get(event.getUid());
                            if (target != null) {
                                this.removeCalendar(collection, target.getUid().getValue());
                            }
                        }
                        break block10;
                    }
                    throw new AxelorException(4, I18n.get((String)"Calendar configuration not valid"));
                }
                catch (Exception e) {
                    throw new ICalendarException(e);
                }
                finally {
                    store.disconnect();
                }
            }
        }
    }

    @Transactional
    public void removeOldEvents(List<ICalendarEvent> oldEvents) {
        for (ICalendarEvent event : oldEvents) {
            this.iEventRepo.remove((Model)((Object)event));
        }
    }

    private List<ICalendarEvent> getICalendarEvents(ICalendar calendar) {
        LocalDateTime lastSynchro = calendar.getLastSynchronizationDateT();
        if (lastSynchro != null) {
            return this.iEventRepo.all().filter("COALESCE(self.archived, false) = false AND self.calendar = ?1 AND COALESCE(self.updatedOn, self.createdOn) > ?2", new Object[]{calendar, lastSynchro}).fetch();
        }
        return this.iEventRepo.all().filter("COALESCE(self.archived, false) = false AND self.calendar = ?1", new Object[]{calendar}).fetch();
    }

    public String getCalendarEncryptPassword(String password) {
        return this.mailAccountService.getEncryptPassword(password);
    }

    public String getCalendarDecryptPassword(String password) {
        return this.mailAccountService.getDecryptPassword(password);
    }

    public static class GenericPathResolver
    extends PathResolver {
        private String principalPath;
        private String userPath;

        public String principalPath() {
            return this.principalPath;
        }

        public void setPrincipalPath(String principalPath) {
            this.principalPath = principalPath;
        }

        public String getPrincipalPath(String username) {
            return this.principalPath + "/" + username + "/";
        }

        public String userPath() {
            return this.userPath;
        }

        public void setUserPath(String userPath) {
            this.userPath = userPath;
        }

        public String getUserPath(String username) {
            return this.userPath + "/" + username;
        }
    }
}

