/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.ical;

import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import net.fortuna.ical4j.connector.ObjectNotFoundException;
import net.fortuna.ical4j.connector.ObjectStoreException;
import net.fortuna.ical4j.connector.dav.CalDavCalendarCollection;
import net.fortuna.ical4j.connector.dav.CalDavCalendarStore;
import net.fortuna.ical4j.connector.dav.PathResolver;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.util.CompatibilityHints;
import org.apache.jackrabbit.webdav.DavException;

public class ICalendarStore {
    private CalDavCalendarStore deligateStore;

    public ICalendarStore(URL url, PathResolver pathResolver) {
        this.deligateStore = new CalDavCalendarStore("-//Axelor//ADK Calendar 1.0//EN", url, pathResolver);
    }

    public boolean connect(String username, String password) throws ObjectStoreException {
        if (this.deligateStore.isConnected()) {
            return true;
        }
        return this.deligateStore.connect(username, password.toCharArray());
    }

    public boolean connect() {
        if (this.deligateStore.isConnected()) {
            return true;
        }
        try {
            return this.deligateStore.connect();
        }
        catch (ObjectStoreException objectStoreException) {
            return false;
        }
    }

    public void disconnect() {
        if (this.deligateStore.isConnected()) {
            this.deligateStore.disconnect();
        }
    }

    public CalDavCalendarCollection getCollection(String id) throws ObjectStoreException, ObjectNotFoundException {
        return this.deligateStore.getCollection(id);
    }

    public List<CalDavCalendarCollection> getCollections() throws ObjectStoreException {
        try {
            return this.deligateStore.getCollections();
        }
        catch (ObjectNotFoundException e) {
            e.printStackTrace();
            return new ArrayList<CalDavCalendarCollection>();
        }
    }

    public static List<VEvent> getEvents(CalDavCalendarCollection calendar) {
        ArrayList<VEvent> events = new ArrayList<VEvent>();
        for (Calendar cal : calendar.getEvents()) {
            for (Object item : cal.getComponents("VEVENT")) {
                VEvent event = (VEvent)item;
                events.add(event);
            }
        }
        return events;
    }

    public static List<VEvent> getModifiedEvents(CalDavCalendarCollection calendar, Instant instant, Set<String> remoteUids) {
        ArrayList<VEvent> events = new ArrayList<VEvent>();
        for (Calendar cal : calendar.getEvents()) {
            cal.toString();
            for (Object item : cal.getComponents("VEVENT")) {
                VEvent event = (VEvent)item;
                if (instant == null || event.getLastModified().getDate().toInstant().isAfter(instant)) {
                    events.add(event);
                }
                remoteUids.add(event.getUid().getValue());
            }
        }
        return events;
    }

    public static List<VEvent> getModifiedEventsInRange(CalDavCalendarCollection calendar, Instant instant, Set<String> remoteUids, LocalDateTime startDate, LocalDateTime endDate) throws IOException, DavException, ParserConfigurationException, ParserException, ParseException {
        ArrayList<VEvent> events = new ArrayList<VEvent>();
        DateTime start = new DateTime(Date.from(startDate.atZone(ZoneId.systemDefault()).toInstant()));
        DateTime end = new DateTime(Date.from(endDate.atZone(ZoneId.systemDefault()).toInstant()));
        start = new DateTime(start.toString() + "Z");
        end = new DateTime(end.toString() + "Z");
        for (Calendar cal : calendar.getEventsForTimePeriod(start, end)) {
            cal.toString();
            for (Object item : cal.getComponents("VEVENT")) {
                VEvent event = (VEvent)item;
                if (event.getLastModified().getDate().toInstant().isAfter(instant)) {
                    events.add(event);
                }
                remoteUids.add(event.getUid().getValue());
            }
        }
        return events;
    }

    public CalDavCalendarStore getDelegateStore() {
        return this.deligateStore;
    }

    static {
        CompatibilityHints.setHintEnabled((String)"ical4j.parsing.relaxed", (boolean)true);
        CompatibilityHints.setHintEnabled((String)"ical4j.compatibility.outlook", (boolean)true);
        CompatibilityHints.setHintEnabled((String)"ical4j.unfolding.relaxed", (boolean)true);
        CompatibilityHints.setHintEnabled((String)"ical4j.validation.relaxed", (boolean)true);
        CompatibilityHints.setHintEnabled((String)"ical4j.compatibility.notes", (boolean)true);
    }
}

