/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service;

import com.axelor.apps.base.db.AdjustHistory;
import com.axelor.apps.base.db.Period;
import com.axelor.apps.base.db.Year;
import com.axelor.apps.base.db.repo.AdjustHistoryRepository;
import com.axelor.db.Model;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.time.LocalDateTime;

public class AdjustHistoryService {
    private AdjustHistoryRepository adjustHistoryRepo;

    @Inject
    public AdjustHistoryService(AdjustHistoryRepository adjustHistoryRepo) {
        this.adjustHistoryRepo = adjustHistoryRepo;
    }

    @Transactional
    public void setStartDate(Year year) {
        AdjustHistory adjustHistory = new AdjustHistory();
        adjustHistory.setFiscalYear(year);
        adjustHistory.setStartDate(LocalDateTime.now());
        this.adjustHistoryRepo.save((Model)((Object)adjustHistory));
    }

    @Transactional
    public void setStartDate(Period period) {
        AdjustHistory adjustHistory = new AdjustHistory();
        adjustHistory.setPeriod(period);
        adjustHistory.setStartDate(LocalDateTime.now());
        this.adjustHistoryRepo.save((Model)((Object)adjustHistory));
    }

    @Transactional
    public AdjustHistory setEndDate(Year year) {
        AdjustHistory adjustHistory = (AdjustHistory)((Object)this.adjustHistoryRepo.all().filter("self.fiscalYear.id = ? AND self.endDate IS NULL", new Object[]{year.getId()}).fetchOne());
        adjustHistory.setEndDate(LocalDateTime.now());
        this.adjustHistoryRepo.save((Model)((Object)adjustHistory));
        return adjustHistory;
    }

    @Transactional
    public void setEndDate(Period period) {
        AdjustHistory adjustHistory = (AdjustHistory)((Object)this.adjustHistoryRepo.all().filter("self.period.id = ? AND self.endDate IS NULL", new Object[]{period.getId()}).fetchOne());
        adjustHistory.setEndDate(LocalDateTime.now());
        this.adjustHistoryRepo.save((Model)((Object)adjustHistory));
    }
}

