/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service;

import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.base.db.Bank;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.service.BankDetailsService;
import com.axelor.apps.tool.StringTool;
import com.axelor.exception.AxelorException;
import org.iban4j.CountryCode;
import org.iban4j.IbanFormatException;
import org.iban4j.IbanUtil;
import org.iban4j.InvalidCheckDigitException;
import org.iban4j.UnsupportedCountryException;

public class BankDetailsServiceImpl
implements BankDetailsService {
    @Override
    public BankDetails detailsIban(BankDetails bankDetails) {
        if (bankDetails.getIban() != null) {
            bankDetails.setBankCode(StringTool.extractStringFromRight((String)bankDetails.getIban(), (int)23, (int)5));
            bankDetails.setSortCode(StringTool.extractStringFromRight((String)bankDetails.getIban(), (int)18, (int)5));
            bankDetails.setAccountNbr(StringTool.extractStringFromRight((String)bankDetails.getIban(), (int)13, (int)11));
            bankDetails.setBbanKey(StringTool.extractStringFromRight((String)bankDetails.getIban(), (int)2, (int)2));
        }
        return bankDetails;
    }

    @Override
    public BankDetails createBankDetails(String accountNbr, String bankCode, String bbanKey, Bank bank, String ownerName, Partner partner, String sortCode) {
        BankDetails bankDetails = new BankDetails();
        bankDetails.setAccountNbr(accountNbr);
        bankDetails.setBankCode(bankCode);
        bankDetails.setBbanKey(bbanKey);
        bankDetails.setBank(bank);
        bankDetails.setOwnerName(ownerName);
        bankDetails.setPartner(partner);
        bankDetails.setSortCode(sortCode);
        return bankDetails;
    }

    @Override
    public String createCompanyBankDetailsDomain(Partner partner, Company company, PaymentMode paymentMode, Integer operationTypeSelect) throws AxelorException {
        if (company == null) {
            return "self.id IN (0)";
        }
        return "self.id IN (" + StringTool.getIdListString(company.getBankDetailsSet()) + ") AND self.active = true";
    }

    @Override
    public BankDetails getDefaultCompanyBankDetails(Company company, PaymentMode paymentMode, Partner partner, Integer operationTypeSelect) throws AxelorException {
        BankDetails bankDetails = company.getDefaultBankDetails();
        if (bankDetails != null && bankDetails.getActive().booleanValue()) {
            return company.getDefaultBankDetails();
        }
        return null;
    }

    @Override
    public String getActiveCompanyBankDetails(Company company, Currency currency) {
        String domain = this.getActiveCompanyBankDetails(company);
        if (currency != null) {
            String fileFormatCurrencyId = currency.getId().toString();
            domain = domain + " AND (self.currency IS NULL OR self.currency.id = " + fileFormatCurrencyId + ")";
        }
        return domain;
    }

    @Override
    public String getActiveCompanyBankDetails(Company company) {
        String domain = "";
        if (company != null) {
            String bankDetailsIds = StringTool.getIdListString(company.getBankDetailsSet());
            if (company.getDefaultBankDetails() != null) {
                bankDetailsIds = bankDetailsIds + (bankDetailsIds.equals("") ? "" : ",");
                bankDetailsIds = bankDetailsIds + company.getDefaultBankDetails().getId().toString();
            }
            if (bankDetailsIds.equals("")) {
                return "";
            }
            domain = "self.id IN(" + bankDetailsIds + ")";
        }
        if (domain.equals("")) {
            return domain;
        }
        domain = domain + " AND self.active = true";
        return domain;
    }

    @Override
    public void validateIban(String iban) throws IbanFormatException, InvalidCheckDigitException, UnsupportedCountryException {
        CountryCode countryCode = CountryCode.getByCode((String)IbanUtil.getCountryCode((String)iban));
        if (countryCode == null) {
            throw new UnsupportedCountryException("Country code is not supported.");
        }
        if (IbanUtil.isSupportedCountry((CountryCode)countryCode)) {
            IbanUtil.validate((String)iban);
        }
    }
}

