/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service;

import com.axelor.apps.base.db.AppBase;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.CurrencyConversionLine;
import com.axelor.apps.base.db.repo.CurrencyConversionLineRepository;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.LocalDate;
import java.time.Period;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wslite.http.HTTPClient;
import wslite.http.HTTPMethod;
import wslite.http.HTTPRequest;
import wslite.http.HTTPResponse;
import wslite.json.JSONArray;
import wslite.json.JSONException;
import wslite.json.JSONObject;

@Singleton
public class CurrencyConversionService {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Inject
    protected AppBaseService appBaseService;
    @Inject
    protected CurrencyConversionLineRepository cclRepo;

    public void updateCurrencyConverion() throws AxelorException {
        AppBase appBase = this.appBaseService.getAppBase();
        LocalDate today = this.appBaseService.getTodayDate();
        HashMap currencyMap = new HashMap();
        for (CurrencyConversionLine ccl : appBase.getCurrencyConversionLineList()) {
            if (currencyMap.containsKey(ccl.getEndCurrency().getId())) {
                ((Set)currencyMap.get(ccl.getEndCurrency().getId())).add(ccl.getStartCurrency().getId());
                continue;
            }
            HashSet<Long> startCurrencyIds = new HashSet<Long>();
            startCurrencyIds.add(ccl.getStartCurrency().getId());
            currencyMap.put(ccl.getEndCurrency().getId(), startCurrencyIds);
        }
        for (Long key : currencyMap.keySet()) {
            List cclList = this.cclRepo.all().filter("startCurrency.id IN (?1) AND endCurrency.id = ?2 AND fromDate <= ?3 AND toDate is null", new Object[]{currencyMap.get(key), key, today}).fetch();
            for (CurrencyConversionLine ccl : cclList) {
                LOG.trace("Currency Conversion Line without toDate : {}", (Object)ccl);
                BigDecimal currentRate = BigDecimal.ZERO;
                try {
                    currentRate = this.convert(ccl.getStartCurrency(), ccl.getEndCurrency());
                }
                catch (Exception e) {
                    TraceBackService.trace((Throwable)e);
                }
                if (currentRate.compareTo(new BigDecimal(-1)) == 0) {
                    throw new AxelorException(4, I18n.get((String)"Currency conversion webservice not working"));
                }
                BigDecimal previousRate = (ccl = (CurrencyConversionLine)((Object)this.cclRepo.find(ccl.getId()))).getExchangeRate();
                if (currentRate.compareTo(previousRate) == 0) continue;
                ccl.setToDate(today.minusDays(1L));
                this.saveCurrencyConversionLine(ccl);
                String variations = this.getVariations(currentRate, previousRate);
                this.createCurrencyConversionLine(ccl.getStartCurrency(), ccl.getEndCurrency(), today, currentRate, appBase, variations);
            }
        }
    }

    public BigDecimal convert(Currency currencyFrom, Currency currencyTo) throws MalformedURLException, JSONException, AxelorException {
        BigDecimal rate = new BigDecimal(-1);
        LOG.trace("Currerncy conversion From: {} To: {}", new Object[]{currencyFrom, currencyTo});
        String wsUrl = this.appBaseService.getAppBase().getCurrencyWsURL();
        if (wsUrl == null) {
            LOG.trace("Currency WS URL not configured");
            return rate;
        }
        if (currencyFrom != null && currencyTo != null) {
            Float rt = this.validateAndGetRate(1, wsUrl, currencyFrom, currencyTo, this.appBaseService.getTodayDate());
            rate = BigDecimal.valueOf(rt.floatValue()).setScale(8, RoundingMode.HALF_EVEN);
        } else {
            LOG.trace("Currency from and to must be filled to get rate");
        }
        LOG.trace("Currerncy conversion rate: {}", new Object[]{rate});
        return rate;
    }

    private Float validateAndGetRate(int dayCount, String wsUrl, Currency currencyFrom, Currency currencyTo, LocalDate date) throws MalformedURLException, JSONException, AxelorException {
        HTTPResponse response = null;
        if (dayCount < 8) {
            HTTPClient httpclient = new HTTPClient();
            HTTPRequest request = new HTTPRequest();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Accept", "application/json");
            request.setHeaders(headers);
            URL url = new URL(String.format(wsUrl, currencyFrom.getCode(), currencyTo.getCode(), date, date));
            LOG.trace("Currency conversion webservice URL: {}", new Object[]{url.toString()});
            request.setUrl(url);
            request.setMethod(HTTPMethod.GET);
            try {
                response = httpclient.execute(request);
            }
            catch (Exception e) {
                throw new AxelorException(4, I18n.get((String)"Currency conversion webservice not working"));
            }
            LOG.trace("Webservice response code: {}, response message: {}", (Object)response.getStatusCode(), (Object)response.getStatusMessage());
            if (response.getStatusCode() != 200) {
                return Float.valueOf(-1.0f);
            }
        } else {
            throw new AxelorException(4, String.format(I18n.get((String)"No currency conversion rate found for the date %s to %s. Please change the conversion date"), date.plus(Period.ofDays(1)), this.appBaseService.getTodayDate()));
        }
        if (response.getContentAsString().isEmpty()) {
            return this.validateAndGetRate(dayCount + 1, wsUrl, currencyFrom, currencyTo, date.minus(Period.ofDays(1)));
        }
        return this.getRateFromJson(currencyFrom, currencyTo, response);
    }

    private Float getRateFromJson(Currency currencyFrom, Currency currencyTo, HTTPResponse response) throws JSONException {
        int compareCode = currencyFrom.getCode().compareTo(currencyTo.getCode());
        Float rt = null;
        String[] currencyRateArr = new String[2];
        JSONObject jsonResult = new JSONObject(response.getContentAsString());
        JSONObject dataSets = new JSONObject(jsonResult.getJSONArray("dataSets").get(0).toString());
        JSONObject series = new JSONObject(dataSets.getJSONObject("series").toString());
        JSONObject seriesOf = null;
        JSONObject observations = null;
        JSONArray rateValue = null;
        if (series.size() > 1) {
            for (int i = 0; i < series.size(); ++i) {
                seriesOf = new JSONObject(series.getJSONObject("0:" + i + ":0:0:0").toString());
                observations = new JSONObject(seriesOf.getJSONObject("observations").toString());
                rateValue = new JSONArray(observations.get((Object)(observations.length() - 1)).toString());
                currencyRateArr[i] = rateValue.get(0).toString();
            }
            rt = compareCode > 0 ? Float.valueOf(Float.parseFloat(currencyRateArr[0]) / Float.parseFloat(currencyRateArr[1])) : Float.valueOf(Float.parseFloat(currencyRateArr[1]) / Float.parseFloat(currencyRateArr[0]));
        } else {
            seriesOf = new JSONObject(series.getJSONObject("0:0:0:0:0").toString());
            observations = new JSONObject(seriesOf.getJSONObject("observations").toString());
            rateValue = new JSONArray(observations.get((Object)(observations.length() - 1)).toString());
            rt = currencyTo.getCode().equals("EUR") ? Float.valueOf(1.0f / Float.parseFloat(rateValue.get(0).toString())) : Float.valueOf(Float.parseFloat(rateValue.get(0).toString()));
        }
        return rt;
    }

    public String getVariations(BigDecimal currentRate, BigDecimal previousRate) {
        String variations = "0";
        LOG.trace("Currency rate variation calculation for CurrentRate: {} PreviousRate: {}", new Object[]{currentRate, previousRate});
        if (currentRate != null && previousRate != null && previousRate.compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal diffRate = currentRate.subtract(previousRate);
            BigDecimal variation = diffRate.multiply(new BigDecimal(100)).divide(previousRate, RoundingMode.HALF_EVEN);
            variation = variation.setScale(2, RoundingMode.HALF_EVEN);
            variations = variation.toString() + "%";
        }
        LOG.trace("Currency rate variation result: {}", new Object[]{variations});
        return variations;
    }

    @Transactional
    public void createCurrencyConversionLine(Currency currencyFrom, Currency currencyTo, LocalDate fromDate, BigDecimal rate, AppBase appBase, String variations) {
        LOG.trace("Create new currency conversion line CurrencyFrom: {}, CurrencyTo: {},FromDate: {},ConversionRate: {}, AppBase: {}, Variations: {}", new Object[]{currencyFrom, currencyTo, fromDate, rate, appBase, variations});
        CurrencyConversionLine ccl = new CurrencyConversionLine();
        ccl.setStartCurrency(currencyFrom);
        ccl.setEndCurrency(currencyTo);
        ccl.setFromDate(fromDate);
        ccl.setExchangeRate(rate);
        ccl.setAppBase(appBase);
        ccl.setVariations(variations);
        this.cclRepo.save((Model)((Object)ccl));
    }

    @Transactional
    public void saveCurrencyConversionLine(CurrencyConversionLine ccl) {
        this.cclRepo.save((Model)((Object)ccl));
    }
}

