/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service;

import com.axelor.db.JPA;
import com.axelor.db.JpaSecurity;
import com.axelor.db.Model;
import com.axelor.db.mapper.Mapper;
import com.axelor.db.mapper.Property;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.db.MetaField;
import com.axelor.meta.db.repo.MetaFieldRepository;
import com.axelor.rpc.filter.Filter;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DuplicateObjectsService {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Logger log = LoggerFactory.getLogger(DuplicateObjectsService.class);
    @Inject
    private MetaFieldRepository metaFieldRepo;

    @Transactional
    public void removeDuplicate(List<Long> selectedIds, String modelName) {
        List<Object> duplicateObjects = this.getDuplicateObject(selectedIds, modelName);
        Object originalObjct = this.getOriginalObject(selectedIds, modelName);
        List allField = this.metaFieldRepo.all().filter("(relationship = 'ManyToOne' AND typeName = ?1) OR (relationship = 'ManyToMany' AND (typeName = ?1 OR metaModel.name =?1))", new Object[]{modelName}).fetch();
        for (MetaField metaField : allField) {
            if ("ManyToOne".equals(metaField.getRelationship())) {
                Query update = JPA.em().createQuery("UPDATE " + metaField.getMetaModel().getFullName() + " self SET self." + metaField.getName() + " = :value WHERE self." + metaField.getName() + " in (:duplicates)");
                update.setParameter("value", originalObjct);
                update.setParameter("duplicates", duplicateObjects);
                update.executeUpdate();
                continue;
            }
            if (!"ManyToMany".equals(metaField.getRelationship())) continue;
            if (metaField.getTypeName().equals(modelName)) {
                Query select = JPA.em().createQuery("select self from " + metaField.getMetaModel().getFullName() + " self LEFT JOIN self." + metaField.getName() + " as x WHERE x IN (:ids)");
                select.setParameter("ids", duplicateObjects);
                List list = select.getResultList();
                for (Object obj : list) {
                    Set items = (Set)Mapper.of(obj.getClass()).get(obj, metaField.getName());
                    for (Object dupObj : duplicateObjects) {
                        if (!items.contains(dupObj)) continue;
                        items.remove(dupObj);
                    }
                    items.add(originalObjct);
                }
            }
            Mapper mapper = Mapper.of(originalObjct.getClass());
            Set existRelationalObjects = (Set)mapper.get(originalObjct, metaField.getName());
            for (int i = 0; i < duplicateObjects.size(); ++i) {
                Set newRelationalObjects = (Set)mapper.get(duplicateObjects.get(i), metaField.getName());
                if (newRelationalObjects == null) continue;
                existRelationalObjects.addAll(newRelationalObjects);
                mapper.set(duplicateObjects.get(i), metaField.getName(), new HashSet());
            }
        }
        JPA.em().flush();
        JPA.em().clear();
        for (Object obj : this.getDuplicateObject(selectedIds, modelName)) {
            JPA.em().remove(obj);
        }
    }

    @Transactional
    public Object getOriginalObject(List<Long> selectedIds, String modelName) {
        Query originalObj = JPA.em().createQuery("SELECT self FROM " + modelName + " self WHERE self.id = :ids");
        originalObj.setParameter("ids", (Object)selectedIds.get(0));
        Object originalObjct = originalObj.getSingleResult();
        return originalObjct;
    }

    @Transactional
    public List<Object> getDuplicateObject(List<Long> selectedIds, String modelName) {
        Query duplicateObj = JPA.em().createQuery("SELECT self FROM " + modelName + " self WHERE self.id IN (:ids)");
        duplicateObj.setParameter("ids", selectedIds.subList(1, selectedIds.size()));
        List duplicateObjects = duplicateObj.getResultList();
        return duplicateObjects;
    }

    @Transactional
    public List<Object> getAllSelectedObject(List<Long> selectedIds, String modelName) {
        Query duplicateObj = JPA.em().createQuery("SELECT self FROM " + modelName + " self WHERE self.id IN (:ids)");
        duplicateObj.setParameter("ids", selectedIds);
        List duplicateObjects = duplicateObj.getResultList();
        return duplicateObjects;
    }

    @Transactional
    public Object getWizardValue(Long id, String modelName, String nameColumn) {
        Query selectedObj = nameColumn == null ? JPA.em().createQuery("SELECT self.id FROM " + modelName + " self WHERE self.id = :id") : JPA.em().createQuery("SELECT self.id ,self." + nameColumn + " FROM " + modelName + " self WHERE self.id = :id");
        selectedObj.setParameter("id", (Object)id);
        Object selectedObject = selectedObj.getSingleResult();
        return selectedObject;
    }

    public Filter getJpaSecurityFilter(Class<? extends Model> beanClass) {
        JpaSecurity jpaSecurity = (JpaSecurity)Beans.get(JpaSecurity.class);
        return jpaSecurity.getFilter(JpaSecurity.CAN_READ, beanClass, new Long[]{null});
    }

    public List<?> findDuplicatedRecordIds(Set<String> fieldSet, Class<? extends Model> modelClass, String filter) throws AxelorException {
        if (fieldSet == null || fieldSet.isEmpty()) {
            return null;
        }
        String concatedFields = this.concatFields(modelClass, fieldSet);
        String subQuery = this.createSubQuery(modelClass, filter, concatedFields);
        this.log.debug("Duplicate check subquery: {}", (Object)concatedFields);
        return this.fetchDuplicatedRecordIds(modelClass, concatedFields, subQuery, filter);
    }

    private String concatFields(Class<?> modelClass, Set<String> fieldSet) throws AxelorException {
        StringBuilder fields = new StringBuilder("LOWER(concat(");
        Mapper mapper = Mapper.of(modelClass);
        int count = 0;
        for (String field : fieldSet) {
            Property property = mapper.getProperty(field);
            if (property == null) {
                throw new AxelorException(4, I18n.get((String)"Duplicate finder field '%s' is not found inside model '%s'"), new Object[]{field, modelClass.getSimpleName()});
            }
            if (property.isCollection()) {
                throw new AxelorException(4, I18n.get((String)"Invalid duplicate finder field '%s'. Field type ManyToMany or OneToMany is not supported for duplicate check"), new Object[]{field});
            }
            if (count != 0) {
                fields.append(",");
            }
            ++count;
            fields.append("cast(self." + field);
            if (property.getTarget() != null) {
                fields.append(".id");
            }
            fields.append(" as string)");
        }
        fields.append("))");
        return fields.toString();
    }

    private String createSubQuery(Class<?> modelClass, String filter, String concatedFields) {
        StringBuilder queryBuilder = new StringBuilder("SELECT ");
        queryBuilder.append(concatedFields);
        queryBuilder.append(" FROM ");
        queryBuilder.append(modelClass.getSimpleName() + " self");
        if (filter != null) {
            queryBuilder.append(" WHERE " + filter);
        }
        queryBuilder.append(" GROUP BY ");
        queryBuilder.append(concatedFields);
        queryBuilder.append(" HAVING COUNT(self) > 1");
        return queryBuilder.toString();
    }

    private List<?> fetchDuplicatedRecordIds(Class<? extends Model> modelClass, String concatedFields, String subQuery, String filter) {
        this.log.debug("Fetch duplicated records for: {}", modelClass);
        StringBuilder queryBuilder = new StringBuilder("SELECT self.id FROM ");
        queryBuilder.append(modelClass.getSimpleName() + " self");
        queryBuilder.append(" WHERE ");
        queryBuilder.append(concatedFields);
        queryBuilder.append(" IN ");
        queryBuilder.append("(" + subQuery + ")");
        if (filter != null) {
            queryBuilder.append(" AND " + filter);
        }
        Filter securityFilter = this.getJpaSecurityFilter(modelClass);
        Object[] params = new Object[]{};
        if (securityFilter != null) {
            queryBuilder.append(" AND (" + securityFilter.getQuery() + ")");
            this.log.debug("JPA filter query: {}", (Object)securityFilter.getQuery());
            params = securityFilter.getParams().toArray();
            this.log.debug("JPA filter params: {}", (Object)securityFilter.getParams());
        }
        String query = queryBuilder.toString();
        this.log.debug("Final query prepared: {}", (Object)query);
        Query finalQuery = JPA.em().createQuery(query);
        for (int i = 0; i < params.length; ++i) {
            finalQuery.setParameter(i, params[i]);
        }
        return finalQuery.getResultList();
    }
}

